/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.infinispan.commons.util.ConcatIterator;
import org.infinispan.commons.util.EntrySizeCalculator;
import org.infinispan.commons.util.FlattenSpliterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.CacheEntrySizeCalculator;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.PrimitiveEntrySizeCalculator;
import org.infinispan.container.impl.AbstractInternalDataContainer;
import org.infinispan.container.impl.DefaultSegmentedDataContainer;
import org.infinispan.container.impl.PeekableTouchableCaffeineMap;
import org.infinispan.container.impl.PeekableTouchableContainerMap;
import org.infinispan.container.impl.PeekableTouchableMap;
import org.infinispan.eviction.EvictionType;
import org.infinispan.marshall.core.WrappedByteArraySizeCalculator;

public class BoundedSegmentedDataContainer<K, V>
extends DefaultSegmentedDataContainer<K, V> {
    protected final Cache<K, InternalCacheEntry<K, V>> evictionCache;
    protected final PeekableTouchableMap<K, V> entries;

    public BoundedSegmentedDataContainer(int numSegments, long thresholdSize, EvictionType thresholdPolicy) {
        super(PeekableTouchableContainerMap::new, numSegments);
        Caffeine caffeine = BoundedSegmentedDataContainer.caffeineBuilder();
        switch (thresholdPolicy) {
            case MEMORY: {
                CacheEntrySizeCalculator calc = new CacheEntrySizeCalculator(new WrappedByteArraySizeCalculator(new PrimitiveEntrySizeCalculator()));
                caffeine.weigher((k, v) -> (int)calc.calculateSize(k, v)).maximumWeight(thresholdSize);
                break;
            }
            case COUNT: {
                caffeine.maximumSize(thresholdSize);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Policy not supported: " + (Object)((Object)thresholdPolicy));
            }
        }
        AbstractInternalDataContainer.DefaultEvictionListener evictionListener = new AbstractInternalDataContainer.DefaultEvictionListener();
        this.evictionCache = this.applyListener(caffeine, evictionListener, new SegmentMapUpdater()).build();
        this.entries = new PeekableTouchableCaffeineMap<K, V>(this.evictionCache);
    }

    public BoundedSegmentedDataContainer(int numSegments, long thresholdSize, EntrySizeCalculator<? super K, ? super InternalCacheEntry<K, V>> sizeCalculator) {
        super(PeekableTouchableContainerMap::new, numSegments);
        AbstractInternalDataContainer.DefaultEvictionListener evictionListener = new AbstractInternalDataContainer.DefaultEvictionListener();
        this.evictionCache = this.applyListener(Caffeine.newBuilder().weigher((k, v) -> (int)sizeCalculator.calculateSize((Object)k, (Object)v)).maximumWeight(thresholdSize), evictionListener, new SegmentMapUpdater()).build();
        this.entries = new PeekableTouchableCaffeineMap<K, V>(this.evictionCache);
    }

    @Override
    protected void computeEntryWritten(K key, InternalCacheEntry<K, V> value) {
        int segment = this.getSegmentForKey(key);
        PeekableTouchableMap map = BoundedSegmentedDataContainer.super.getMapForSegment(segment);
        if (map != null) {
            map.put(key, value);
        }
    }

    @Override
    protected void computeEntryRemoved(K key, InternalCacheEntry<K, V> value) {
        int segment = this.getSegmentForKey(key);
        PeekableTouchableMap map = BoundedSegmentedDataContainer.super.getMapForSegment(segment);
        if (map != null) {
            map.remove(key, value);
        }
    }

    @Override
    public PeekableTouchableMap<K, V> getMapForSegment(int segment) {
        return this.entries;
    }

    @Override
    public InternalCacheEntry<K, V> peek(Object k) {
        return this.peek(-1, k);
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public void clear(IntSet segments) {
        this.clear(segments, false);
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired() {
        return this.entries.values().iterator();
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired(IntSet segments) {
        ArrayList<Collection> valueIterables = new ArrayList<Collection>(segments.size() + 1);
        PrimitiveIterator.OfInt iter = segments.iterator();
        boolean includeOthers = false;
        while (iter.hasNext()) {
            int segment = iter.nextInt();
            ConcurrentMap map = (ConcurrentMap)this.maps.get(segment);
            if (map != null) {
                valueIterables.add(map.values());
                continue;
            }
            includeOthers = true;
        }
        if (includeOthers) {
            valueIterables.add(this.entries.values().stream().filter(e -> segments.contains(this.getSegmentForKey(e.getKey()))).collect(Collectors.toSet()));
        }
        return new ConcatIterator<InternalCacheEntry<K, V>>(valueIterables);
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired() {
        return this.entries.values().spliterator();
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired(IntSet segments) {
        int[] segmentArray = segments.toIntArray();
        AtomicBoolean usedOthers = new AtomicBoolean(false);
        return new FlattenSpliterator<InternalCacheEntry<K, V>>(i -> {
            ConcurrentMap map = (ConcurrentMap)this.maps.get(segmentArray[i]);
            if (map == null) {
                if (!usedOthers.getAndSet(true)) {
                    return this.entries.values().stream().filter(e -> segments.contains(this.getSegmentForKey(e.getKey()))).collect(Collectors.toSet());
                }
                return Collections.emptyList();
            }
            return map.values();
        }, segmentArray.length, 4353);
    }

    @Override
    public int sizeIncludingExpired() {
        return this.entries.size();
    }

    private void clear(IntSet segments, boolean keepSegments) {
        Iterator keyIterator = this.entries.keySet().iterator();
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            int keySegment = this.getSegmentForKey(key);
            if (keepSegments == segments.contains(keySegment)) continue;
            keyIterator.remove();
        }
    }

    @Override
    public void removeSegments(IntSet segments) {
        super.removeSegments(segments);
        this.clear(segments, false);
    }

    private Policy.Eviction<K, InternalCacheEntry<K, V>> eviction() {
        Optional<Policy.Eviction<K, InternalCacheEntry<K, V>>> eviction;
        if (this.evictionCache != null && (eviction = this.evictionCache.policy().eviction()).isPresent()) {
            return eviction.get();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long capacity() {
        Policy.Eviction<K, InternalCacheEntry<K, V>> evict = this.eviction();
        return evict.getMaximum();
    }

    @Override
    public void resize(long newSize) {
        Policy.Eviction<K, InternalCacheEntry<K, V>> evict = this.eviction();
        evict.setMaximum(newSize);
    }

    @Override
    public long evictionSize() {
        Policy.Eviction<K, InternalCacheEntry<K, V>> evict = this.eviction();
        return evict.weightedSize().orElse(this.entries.size());
    }

    @Override
    public void cleanUp() {
        this.evictionCache.cleanUp();
    }

    private class SegmentMapUpdater
    implements CacheWriter<K, InternalCacheEntry<K, V>> {
        private SegmentMapUpdater() {
        }

        @Override
        public void write(K key, InternalCacheEntry<K, V> value) {
            BoundedSegmentedDataContainer.this.computeEntryWritten(key, value);
        }

        @Override
        public void delete(K key, InternalCacheEntry<K, V> value, RemovalCause cause) {
            BoundedSegmentedDataContainer.this.computeEntryRemoved(key, value);
        }
    }
}

