/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;

@ProtoTypeId(value=1004)
public class RemoteMetadata
implements Metadata {
    private final JGroupsAddress address;
    private final SimpleClusteredVersion version;

    public RemoteMetadata(Address address, EntryVersion version) {
        this((JGroupsAddress)address, (SimpleClusteredVersion)version);
    }

    @ProtoFactory
    RemoteMetadata(JGroupsAddress address, SimpleClusteredVersion version) {
        this.address = address;
        this.version = version;
    }

    @ProtoField(number=1, javaType=JGroupsAddress.class)
    public Address getAddress() {
        return this.address;
    }

    @Override
    public long lifespan() {
        return -1L;
    }

    @Override
    public long maxIdle() {
        return -1L;
    }

    @Override
    @ProtoField(number=2, javaType=SimpleClusteredVersion.class)
    public EntryVersion version() {
        return this.version;
    }

    @Override
    public Metadata.Builder builder() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RemoteMetadata{");
        sb.append("address=").append(this.address);
        sb.append(", version=").append(this.version);
        sb.append('}');
        return sb.toString();
    }

    public static class Externalizer
    implements AdvancedExternalizer<RemoteMetadata> {
        @Override
        public Set<Class<? extends RemoteMetadata>> getTypeClasses() {
            return Util.asSet(RemoteMetadata.class);
        }

        @Override
        public Integer getId() {
            return 129;
        }

        @Override
        public void writeObject(ObjectOutput output, RemoteMetadata entry) throws IOException {
            output.writeObject(entry.getAddress());
            if (entry.version != null) {
                output.writeInt(entry.version.getTopologyId());
                output.writeLong(entry.version.getVersion());
            } else {
                output.writeInt(-1);
            }
        }

        @Override
        public RemoteMetadata readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            SimpleClusteredVersion clusteredVersion;
            JGroupsAddress address = (JGroupsAddress)input.readObject();
            int topologyId = input.readInt();
            if (topologyId == -1) {
                clusteredVersion = null;
            } else {
                long version = input.readLong();
                clusteredVersion = new SimpleClusteredVersion(topologyId, version);
            }
            return new RemoteMetadata(address, clusteredVersion);
        }
    }
}

