/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.commons.util.AbstractEntrySizeCalculatorHelper;
import org.infinispan.commons.util.EntrySizeCalculator;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheEntry;
import org.infinispan.container.impl.InternalEntryFactoryImpl;
import org.infinispan.container.impl.KeyValueMetadataSizeCalculator;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;

public class CacheEntrySizeCalculator<K, V>
extends AbstractEntrySizeCalculatorHelper<K, InternalCacheEntry<K, V>>
implements KeyValueMetadataSizeCalculator<K, V> {
    private final EntrySizeCalculator<? super K, ? super V> calculator;

    public CacheEntrySizeCalculator(EntrySizeCalculator<? super K, ? super V> calculator) {
        this.calculator = calculator;
    }

    @Override
    public long calculateSize(K key, InternalCacheEntry<K, V> ice) {
        Metadata metadata;
        boolean metadataAware;
        long noMetadataSize = 0L;
        if (ice instanceof MetadataImmortalCacheEntry) {
            metadataAware = true;
        } else if (ice instanceof ImmortalCacheEntry) {
            metadataAware = false;
        } else if (ice instanceof MortalCacheEntry) {
            noMetadataSize += 16L;
            metadataAware = false;
        } else if (ice instanceof TransientCacheEntry) {
            noMetadataSize += 16L;
            metadataAware = false;
        } else if (ice instanceof TransientMortalCacheEntry) {
            noMetadataSize += 32L;
            metadataAware = false;
        } else {
            metadataAware = ice instanceof MetadataMortalCacheEntry ? true : (ice instanceof MetadataTransientCacheEntry ? true : ice instanceof MetadataTransientMortalCacheEntry);
        }
        if (metadataAware) {
            metadata = ice.getMetadata();
            if (!(metadata instanceof EmbeddedMetadata)) {
                metadata = null;
            }
        } else {
            metadata = null;
        }
        long keyValueMetadataSize = this.calculateSize(key, ice.getValue(), metadata, ice.getInternalMetadata());
        return keyValueMetadataSize + noMetadataSize;
    }

    @Override
    public long calculateSize(K key, V value, Metadata metadata, PrivateMetadata pvtMetadata) {
        long objSize = this.calculator.calculateSize(key, value);
        long iceSize = 0L;
        iceSize += (long)(OBJECT_SIZE + POINTER_SIZE);
        iceSize += (long)(3 * POINTER_SIZE);
        long metadataSize = 0L;
        if (metadata != null) {
            if (metadata.lifespan() != -1L) {
                iceSize += 16L;
            }
            if (metadata.maxIdle() != -1L) {
                iceSize += 16L;
            }
            if (InternalEntryFactoryImpl.isStoreMetadata(metadata, null)) {
                iceSize += (long)POINTER_SIZE;
                metadataSize += (long)(OBJECT_SIZE + POINTER_SIZE);
                metadataSize += (long)POINTER_SIZE;
                metadataSize = CacheEntrySizeCalculator.roundUpToNearest8(metadataSize);
                metadataSize += CacheEntrySizeCalculator.numericVersionSize();
                metadataSize = CacheEntrySizeCalculator.roundUpToNearest8(metadataSize);
            }
        }
        long pvtMetadataSize = pvtMetadata == null || pvtMetadata.isEmpty() ? 0L : CacheEntrySizeCalculator.privateMetadataSize(pvtMetadata);
        return objSize + CacheEntrySizeCalculator.roundUpToNearest8(iceSize) + metadataSize + pvtMetadataSize;
    }

    private static long privateMetadataSize(PrivateMetadata metadata) {
        long size = HEADER_AND_CLASS_REFERENCE;
        size += (long)(2 * POINTER_SIZE);
        size = CacheEntrySizeCalculator.roundUpToNearest8(size);
        if (metadata.iracMetadata() != null) {
            size += CacheEntrySizeCalculator.iracMetadataSize();
        }
        if (metadata.getNumericVersion() != null) {
            size += CacheEntrySizeCalculator.numericVersionSize();
        } else if (metadata.getClusteredVersion() != null) {
            size += CacheEntrySizeCalculator.simpleClusteredVersionSize();
        }
        return size;
    }

    private static long iracMetadataSize() {
        long size = HEADER_AND_CLASS_REFERENCE;
        return CacheEntrySizeCalculator.roundUpToNearest8(size += (long)(2 * POINTER_SIZE));
    }

    private static long numericVersionSize() {
        return CacheEntrySizeCalculator.roundUpToNearest8(HEADER_AND_CLASS_REFERENCE + 8);
    }

    private static long simpleClusteredVersionSize() {
        return CacheEntrySizeCalculator.roundUpToNearest8(HEADER_AND_CLASS_REFERENCE + 4 + 8);
    }
}

