/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.util.BeanUtils;
import org.infinispan.commons.util.Util;
import org.infinispan.util.logging.Log;
import org.w3c.dom.Element;

public class XmlConfigHelper {
    public static Map<Object, Object> setAttributes(AttributeSet attributes, Map<?, ?> attribs, boolean isXmlAttribs, boolean failOnMissingAttribute) {
        HashMap<Object, Object> ignoredAttribs = new HashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : attribs.entrySet()) {
            String name = NamingStrategy.KEBAB_CASE.convert((String)entry.getKey());
            if (attributes.contains(name)) {
                Attribute<Object> attribute = attributes.attribute(name);
                attribute.set(Util.fromString(attribute.getAttributeDefinition().getType(), (String)entry.getValue()));
                continue;
            }
            if (failOnMissingAttribute) {
                throw new CacheConfigurationException("Couldn't find an attribute named [" + name + "] on attribute set [" + attributes.getName() + "]");
            }
            ignoredAttribs.put(name, entry.getValue());
        }
        return ignoredAttribs;
    }

    public static Map<Object, Object> setValues(Object target, Map<?, ?> attribs, boolean isXmlAttribs, boolean failOnMissingSetter) {
        Class<?> objectClass = target.getClass();
        HashMap<Object, Object> ignoredAttribs = new HashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : attribs.entrySet()) {
            String propName = (String)entry.getKey();
            String setter = BeanUtils.setterName(propName);
            String fluentSetter = BeanUtils.fluentSetterName(propName);
            try {
                Method method;
                if (isXmlAttribs) {
                    method = objectClass.getMethod(setter, Element.class);
                    method.invoke(target, entry.getValue());
                    continue;
                }
                method = objectClass.getMethod(setter, String.class);
                method.invoke(target, entry.getValue());
                continue;
            }
            catch (NoSuchMethodException method) {
            }
            catch (Exception e) {
                throw new CacheConfigurationException("Unable to invoke setter " + setter + " on " + objectClass, e);
            }
            boolean setterFound = false;
            for (Method m3 : objectClass.getMethods()) {
                if (!setter.equals(m3.getName()) && !fluentSetter.equals(m3.getName())) continue;
                Class<?>[] paramTypes = m3.getParameterTypes();
                if (paramTypes.length != 1) {
                    Log.CONFIG.tracef("Rejecting setter %s on class %s due to incorrect number of parameters", (Object)m3, (Object)objectClass);
                    continue;
                }
                Class<?> parameterType = paramTypes[0];
                if (parameterType.equals(Class.class)) {
                    Log.CONFIG.tracef("Rejecting setter %s on class %s due to class parameter is type class", (Object)m3, (Object)objectClass);
                    continue;
                }
                Object parameter = Util.fromString(parameterType, (String)attribs.get(propName));
                try {
                    m3.invoke(target, parameter);
                    setterFound = true;
                    break;
                }
                catch (Exception e) {
                    throw new CacheConfigurationException("Unable to invoke setter " + setter + " on " + objectClass, e);
                }
            }
            if (setterFound || propName.startsWith("infinispan.client.hotrod")) continue;
            if (failOnMissingSetter) {
                throw new CacheConfigurationException("Couldn't find a setter named [" + setter + "] which takes a single parameter, for parameter " + propName + " on class [" + objectClass + "]");
            }
            ignoredAttribs.put(propName, attribs.get(propName));
        }
        return ignoredAttribs;
    }

    public static void showUnrecognizedAttributes(Map<Object, Object> attribs) {
        for (Object propName : attribs.keySet()) {
            Log.CONFIG.unrecognizedAttribute((String)propName);
        }
    }
}

