/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.flowables.GroupedFlowable;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.parsing.SFSToSIFSConfiguration;
import org.infinispan.persistence.internal.PersistenceUtil;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfiguration;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.support.DelegatingInitializationContext;
import org.infinispan.persistence.support.DelegatingNonBlockingStore;
import org.infinispan.persistence.support.SegmentPublisherWrapper;
import org.infinispan.util.concurrent.CompletionStages;

@ConfiguredBy(value=SFSToSIFSConfiguration.class)
public class SFSToSIFSStore<K, V>
extends DelegatingNonBlockingStore<K, V> {
    private NonBlockingStore<K, V> targetStore;

    @Override
    public NonBlockingStore<K, V> delegate() {
        return this.targetStore;
    }

    @Override
    public CompletionStage<Void> start(InitializationContext ctx) {
        SFSToSIFSConfiguration sfsToSIFSConfiguration = (SFSToSIFSConfiguration)ctx.getConfiguration();
        CompletionStage<NonBlockingStore<K, V>> targetStage = this.createAndStartSoftIndexFileStore(ctx, sfsToSIFSConfiguration);
        if (sfsToSIFSConfiguration.purgeOnStartup()) {
            return targetStage.thenAccept(sifsStore -> {
                this.targetStore = sifsStore;
            });
        }
        CompletionStage<NonBlockingStore<K, V>> nonSegmentedSFSStage = this.createAndStartSingleFileStore(ctx, sfsToSIFSConfiguration.dataLocation(), false);
        CompletionStage<NonBlockingStore<K, V>> segmentedSFSStage = this.createAndStartSingleFileStore(ctx, sfsToSIFSConfiguration.dataLocation(), true);
        Function<NonBlockingStore, CompletionStage> composed = sourceStore -> targetStage.thenCompose(targetStore -> {
            this.targetStore = targetStore;
            int segmentCount = ctx.getCache().getCacheConfiguration().clustering().hash().numSegments();
            IntSet allSegments = IntSets.immutableRangeSet(segmentCount);
            Flowable<GroupedFlowable<Integer, MarshallableEntry>> groupedFlowable = Flowable.fromPublisher(sourceStore.publishEntries(allSegments, null, true)).groupBy(ctx.getKeyPartitioner()::getSegment);
            return targetStore.batch(segmentCount, Flowable.empty(), groupedFlowable.map(SegmentPublisherWrapper::wrap)).thenCompose(ignore -> sourceStore.destroy());
        });
        return CompletionStages.allOf(nonSegmentedSFSStage.thenCompose(composed), segmentedSFSStage.thenCompose(composed));
    }

    CompletionStage<NonBlockingStore<K, V>> createAndStartSingleFileStore(InitializationContext ctx, String location, boolean segmented) {
        AttributeSet sfsAttributes = SingleFileStoreConfiguration.attributeDefinitionSet();
        sfsAttributes.attribute(SingleFileStoreConfiguration.LOCATION).set(location);
        sfsAttributes.attribute(AbstractStoreConfiguration.SEGMENTED).set(segmented);
        sfsAttributes.attribute(AbstractStoreConfiguration.READ_ONLY).set(Boolean.TRUE);
        return this.createAndStartStore(ctx, new SingleFileStoreConfiguration(sfsAttributes.protect(), new AsyncStoreConfiguration(AsyncStoreConfiguration.attributeDefinitionSet().protect())));
    }

    CompletionStage<NonBlockingStore<K, V>> createAndStartSoftIndexFileStore(InitializationContext ctx, SFSToSIFSConfiguration config) {
        return this.createAndStartStore(ctx, new SoftIndexFileStoreConfiguration(config.attributes(), config.async(), config.index(), config.data()));
    }

    private CompletionStage<NonBlockingStore<K, V>> createAndStartStore(final InitializationContext ctx, final StoreConfiguration storeConfiguration) {
        NonBlockingStore store = PersistenceUtil.storeFromConfiguration(storeConfiguration);
        return store.start(new DelegatingInitializationContext(){

            @Override
            public InitializationContext delegate() {
                return ctx;
            }

            @Override
            public <T extends StoreConfiguration> T getConfiguration() {
                return (T)storeConfiguration;
            }
        }).thenApply(ignore -> store);
    }
}

