/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.SFSToSIFSConfiguration;
import org.infinispan.persistence.sifs.configuration.DataConfiguration;
import org.infinispan.persistence.sifs.configuration.IndexConfiguration;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfiguration;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.infinispan.util.logging.Log;

public class SFSToSIFSConfigurationBuilder
extends SoftIndexFileStoreConfigurationBuilder {
    public SFSToSIFSConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public SoftIndexFileStoreConfiguration create() {
        return new SFSToSIFSConfiguration(this.attributes.protect(), this.async.create(), this.index.create(), this.data.create());
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        Attribute<String> dataLocation;
        Attribute<String> indexLocation;
        if (!globalConfig.globalState().enabled() && !(indexLocation = this.index.attributes().attribute(IndexConfiguration.INDEX_LOCATION)).isModified() && (dataLocation = this.data.attributes().attribute(DataConfiguration.DATA_LOCATION)).isModified()) {
            String indexLocationString = dataLocation.get() + "-index";
            Log.CONFIG.debugf("Setting index location for migrated FileStore to %s", (Object)indexLocationString);
            indexLocation.set(indexLocationString);
        }
        super.validate(globalConfig);
    }
}

