/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class StateTransferConfiguration
extends ConfigurationElement<StateTransferConfiguration> {
    public static final AttributeDefinition<Boolean> AWAIT_INITIAL_TRANSFER = AttributeDefinition.builder(Attribute.AWAIT_INITIAL_TRANSFER, Boolean.valueOf(true)).immutable().build();
    public static final AttributeDefinition<Boolean> FETCH_IN_MEMORY_STATE = AttributeDefinition.builder(Attribute.ENABLED, Boolean.valueOf(true)).immutable().build();
    public static final AttributeDefinition<Long> TIMEOUT = AttributeDefinition.builder(Attribute.TIMEOUT, Long.valueOf(TimeUnit.MINUTES.toMillis(4L))).immutable().build();
    public static final AttributeDefinition<Integer> CHUNK_SIZE = AttributeDefinition.builder(Attribute.CHUNK_SIZE, Integer.valueOf(512)).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> awaitInitialTransfer;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> fetchInMemoryState;
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> timeout;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> chunkSize;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(StateTransferConfiguration.class, FETCH_IN_MEMORY_STATE, TIMEOUT, CHUNK_SIZE, AWAIT_INITIAL_TRANSFER);
    }

    StateTransferConfiguration(AttributeSet attributes) {
        super(Element.STATE_TRANSFER, attributes, new ConfigurationElement[0]);
        this.awaitInitialTransfer = attributes.attribute(AWAIT_INITIAL_TRANSFER);
        this.fetchInMemoryState = attributes.attribute(FETCH_IN_MEMORY_STATE);
        this.timeout = attributes.attribute(TIMEOUT);
        this.chunkSize = attributes.attribute(CHUNK_SIZE);
    }

    public boolean fetchInMemoryState() {
        return this.fetchInMemoryState.get();
    }

    public long timeout() {
        return this.timeout.get();
    }

    @Deprecated
    public StateTransferConfiguration timeout(long l) {
        this.timeout.set(l);
        return this;
    }

    public int chunkSize() {
        return this.chunkSize.get();
    }

    public boolean awaitInitialTransfer() {
        return this.awaitInitialTransfer.get();
    }

    private boolean originalAwaitInitialTransfer() {
        return !this.awaitInitialTransfer.isModified();
    }
}

