/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.util.logging.Log;

public class PartitionHandlingConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<PartitionHandlingConfiguration> {
    private final AttributeSet attributes = PartitionHandlingConfiguration.attributeDefinitionSet();

    public PartitionHandlingConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    PartitionHandling whenSplit() {
        return this.attributes.attribute(PartitionHandlingConfiguration.WHEN_SPLIT).get();
    }

    public PartitionHandlingConfigurationBuilder whenSplit(PartitionHandling partitionHandling) {
        this.attributes.attribute(PartitionHandlingConfiguration.WHEN_SPLIT).set(partitionHandling);
        return this;
    }

    public PartitionHandlingConfigurationBuilder mergePolicy(EntryMergePolicy mergePolicy) {
        this.attributes.attribute(PartitionHandlingConfiguration.MERGE_POLICY).set(mergePolicy);
        return this;
    }

    @Override
    public void validate() {
        if (this.attributes.attribute(PartitionHandlingConfiguration.WHEN_SPLIT).get() != PartitionHandling.ALLOW_READ_WRITES && this.clustering().cacheMode().isInvalidation()) {
            throw Log.CONFIG.invalidationPartitionHandlingNotSuported();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public PartitionHandlingConfiguration create() {
        return new PartitionHandlingConfiguration(this.attributes.protect());
    }

    @Override
    public Builder<?> read(PartitionHandlingConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }
}

