/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.infinispan.commons.util.AbstractFileLookup;
import org.infinispan.commons.util.EnumerationList;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.Util;

public class FileLookupFactory {
    public static FileLookup newInstance() {
        return new DefaultFileLookup();
    }

    public static class DefaultFileLookup
    extends AbstractFileLookup
    implements FileLookup {
        protected DefaultFileLookup() {
        }

        @Override
        protected InputStream getAsInputStreamFromClassLoader(String filename, ClassLoader appClassLoader) {
            for (ClassLoader cl : Util.getClassLoaders(appClassLoader)) {
                if (cl == null) continue;
                try {
                    InputStream is = cl.getResourceAsStream(filename);
                    if (is == null) continue;
                    return is;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        protected URL getAsURLFromClassLoader(String filename, ClassLoader userClassLoader) {
            for (ClassLoader cl : Util.getClassLoaders(userClassLoader)) {
                if (cl == null) continue;
                try {
                    URL url = cl.getResource(filename);
                    if (url == null) continue;
                    return url;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        protected Collection<URL> getAsURLsFromClassLoader(String filename, ClassLoader userClassLoader) throws IOException {
            HashSet<URL> urls2 = new HashSet<URL>(4);
            for (ClassLoader cl : Util.getClassLoaders(userClassLoader)) {
                if (cl == null) continue;
                try {
                    urls2.addAll(new EnumerationList<URL>(cl.getResources(filename)));
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return urls2;
        }
    }
}

