/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.executors;

import java.util.AbstractQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.executors.NonBlockingResource;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.concurrent.BlockingRejectedExecutionHandler;
import org.infinispan.commons.util.concurrent.NonBlockingRejectedExecutionHandler;

@Deprecated
public class BlockingThreadPoolExecutorFactory
implements ThreadPoolExecutorFactory<ExecutorService> {
    public static final int DEFAULT_KEEP_ALIVE_MILLIS = 60000;
    private final int maxThreads;
    private final int coreThreads;
    private final int queueLength;
    private final long keepAlive;
    private final boolean nonBlocking;

    public BlockingThreadPoolExecutorFactory(int maxThreads, int coreThreads, int queueLength, long keepAlive) {
        this(maxThreads, coreThreads, queueLength, keepAlive, false);
    }

    public BlockingThreadPoolExecutorFactory(int maxThreads, int coreThreads, int queueLength, long keepAlive, boolean nonBlocking) {
        this.maxThreads = maxThreads;
        this.coreThreads = coreThreads;
        this.queueLength = queueLength;
        this.keepAlive = keepAlive;
        this.nonBlocking = nonBlocking;
    }

    public int maxThreads() {
        return this.maxThreads;
    }

    public int coreThreads() {
        return this.coreThreads;
    }

    public int queueLength() {
        return this.queueLength;
    }

    public long keepAlive() {
        return this.keepAlive;
    }

    @Override
    public boolean createsNonBlockingThreads() {
        return this.nonBlocking;
    }

    @Override
    public ExecutorService createExecutor(ThreadFactory threadFactory2) {
        SynchronousQueue<Runnable> queue;
        AbstractQueue abstractQueue = queue = this.queueLength == 0 ? new SynchronousQueue() : new LinkedBlockingQueue(this.queueLength);
        if (this.nonBlocking && !(threadFactory2 instanceof NonBlockingResource)) {
            throw new IllegalStateException("Executor factory configured to be non blocking and received a thread factory that can create blocking threads!");
        }
        return new ThreadPoolExecutor(this.coreThreads, this.maxThreads, this.keepAlive, TimeUnit.MILLISECONDS, queue, threadFactory2, this.nonBlocking ? NonBlockingRejectedExecutionHandler.getInstance() : BlockingRejectedExecutionHandler.getInstance());
    }

    @Override
    public void validate() {
        if (this.coreThreads < 0) {
            throw Log.CONFIG.illegalValueThreadPoolParameter("core threads", ">= 0");
        }
        if (this.maxThreads <= 0) {
            throw Log.CONFIG.illegalValueThreadPoolParameter("max threads", "> 0");
        }
        if (this.maxThreads < this.coreThreads) {
            throw Log.CONFIG.illegalValueThreadPoolParameter("max threads and core threads", "max threads >= core threads");
        }
        if (this.keepAlive < 0L) {
            throw Log.CONFIG.illegalValueThreadPoolParameter("keep alive time", ">= 0");
        }
        if (this.queueLength < 0) {
            throw Log.CONFIG.illegalValueThreadPoolParameter("work queue length", ">= 0");
        }
    }

    public String toString() {
        return "BlockingThreadPoolExecutorFactory{maxThreads=" + this.maxThreads + ", coreThreads=" + this.coreThreads + ", queueLength=" + this.queueLength + ", keepAlive=" + this.keepAlive + '}';
    }

    public static BlockingThreadPoolExecutorFactory create(int maxThreads, int queueSize, boolean nonBlocking) {
        int coreThreads = queueSize == 0 ? 1 : maxThreads;
        return new BlockingThreadPoolExecutorFactory(maxThreads, coreThreads, queueSize, 60000L, nonBlocking);
    }
}

