/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;

public class PutMapCommand
extends AbstractTopologyAffectedCommand
implements WriteCommand,
MetadataAwareCommand,
RemoteLockCommand {
    public static final byte COMMAND_ID = 9;
    private Map<Object, Object> map;
    private Metadata metadata;
    private boolean isForwarded = false;
    private Map<Object, PrivateMetadata> internalMetadataMap;
    private CommandInvocationId commandInvocationId;

    @Override
    public CommandInvocationId getCommandInvocationId() {
        return this.commandInvocationId;
    }

    public PutMapCommand() {
    }

    public PutMapCommand(Map<?, ?> map, Metadata metadata, long flagsBitSet, CommandInvocationId commandInvocationId) {
        this.map = map;
        this.metadata = metadata;
        this.commandInvocationId = commandInvocationId;
        this.setFlagsBitSet(flagsBitSet);
        this.internalMetadataMap = new HashMap<Object, PrivateMetadata>();
    }

    public PutMapCommand(PutMapCommand command) {
        this.map = command.map;
        this.metadata = command.metadata;
        this.isForwarded = command.isForwarded;
        this.commandInvocationId = command.commandInvocationId;
        this.setFlagsBitSet(command.getFlagsBitSet());
        this.internalMetadataMap = new HashMap<Object, PrivateMetadata>(command.internalMetadataMap);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPutMapCommand(ctx, this);
    }

    @Override
    public Collection<?> getKeysToLock() {
        return this.isForwarded ? Collections.emptyList() : Collections.unmodifiableCollection(this.map.keySet());
    }

    @Override
    public Object getKeyLockOwner() {
        return this.commandInvocationId;
    }

    @Override
    public boolean hasZeroLockAcquisition() {
        return this.hasAnyFlag(FlagBitSets.ZERO_LOCK_ACQUISITION_TIMEOUT);
    }

    @Override
    public boolean hasSkipLocking() {
        return this.hasAnyFlag(FlagBitSets.SKIP_LOCKING);
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    public void setMap(Map<Object, Object> map) {
        this.map = map;
        this.internalMetadataMap.keySet().retainAll(map.keySet());
    }

    public final PutMapCommand withMap(Map<Object, Object> map) {
        this.setMap(map);
        return this;
    }

    @Override
    public byte getCommandId() {
        return 9;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallMap(this.map, output);
        output.writeObject(this.metadata);
        output.writeBoolean(this.isForwarded);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        MarshallUtil.marshallMap(this.internalMetadataMap, output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.map = MarshallUtil.unmarshallMap(input, LinkedHashMap::new);
        this.metadata = (Metadata)input.readObject();
        this.isForwarded = input.readBoolean();
        this.setFlagsBitSet(input.readLong());
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.internalMetadataMap = MarshallUtil.unmarshallMap(input, HashMap::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutMapCommand that = (PutMapCommand)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        int result = this.map != null ? this.map.hashCode() : 0;
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PutMapCommand{map={");
        if (!this.map.isEmpty()) {
            Iterator<Map.Entry<Object, Object>> it = this.map.entrySet().iterator();
            int i = 0;
            while (true) {
                Map.Entry<Object, Object> e = it.next();
                sb.append(Util.toStr(e.getKey())).append('=').append(Util.toStr(e.getValue()));
                if (!it.hasNext()) break;
                if (i > 100) {
                    sb.append(" ...");
                    break;
                }
                sb.append(", ");
                ++i;
            }
        }
        sb.append("}, flags=").append(this.printFlags()).append(", metadata=").append(this.metadata).append(", internalMetadata=").append(this.internalMetadataMap).append(", isForwarded=").append(this.isForwarded).append("}");
        return sb.toString();
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return this.map.keySet();
    }

    @Override
    public void fail() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReturnValueExpected() {
        return !this.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return this.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES) ? VisitableCommand.LoadType.DONT_LOAD : VisitableCommand.LoadType.PRIMARY;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public boolean isForwarded() {
        return this.isForwarded;
    }

    public void setForwarded(boolean forwarded) {
        this.isForwarded = forwarded;
    }

    @Override
    public PrivateMetadata getInternalMetadata(Object key) {
        return this.internalMetadataMap.get(key);
    }

    @Override
    public void setInternalMetadata(Object key, PrivateMetadata internalMetadata) {
        this.internalMetadataMap.put(key, internalMetadata);
    }
}

