/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.GlobalComponentRegistry;

public class RebalancePolicyUpdateCommand
extends AbstractCacheControlCommand {
    public static final byte COMMAND_ID = 88;
    private String cacheName;
    private boolean enabled;

    public RebalancePolicyUpdateCommand() {
        super((byte)88);
    }

    public RebalancePolicyUpdateCommand(String cacheName, boolean enabled) {
        super((byte)88);
        this.cacheName = cacheName;
        this.enabled = enabled;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        return gcr.getClusterTopologyManager().setRebalancingEnabled(this.cacheName, this.enabled);
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallString(this.cacheName, output);
        output.writeBoolean(this.enabled);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.cacheName = MarshallUtil.unmarshallString(input);
        this.enabled = input.readBoolean();
    }

    public String toString() {
        return "RebalanceEnableCommand{cacheName='" + this.cacheName + '\'' + '}';
    }
}

