/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.versioning.irac.IracTombstoneInfo;
import org.infinispan.container.versioning.irac.IracTombstoneManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class IracTombstoneCleanupCommand
implements CacheRpcCommand {
    public static final byte COMMAND_ID = 37;
    private final ByteString cacheName;
    private Collection<IracTombstoneInfo> tombstonesToRemove;

    public IracTombstoneCleanupCommand() {
        this(null, 1);
    }

    public IracTombstoneCleanupCommand(ByteString cacheName) {
        this(cacheName, 1);
    }

    public IracTombstoneCleanupCommand(ByteString cacheName, int maxCapacity) {
        this.cacheName = cacheName;
        this.tombstonesToRemove = new HashSet<IracTombstoneInfo>(maxCapacity);
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    public CompletionStage<Boolean> invokeAsync(ComponentRegistry registry) {
        IracTombstoneManager tombstoneManager = registry.getIracTombstoneManager().running();
        this.tombstonesToRemove.forEach(tombstoneManager::removeTombstone);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 37;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.tombstonesToRemove, output, IracTombstoneInfo::writeTo);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.tombstonesToRemove = MarshallUtil.unmarshallCollection(input, ArrayList::new, IracTombstoneInfo::readFrom);
    }

    @Override
    public Address getOrigin() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
    }

    public String toString() {
        return "IracTombstoneCleanupCommand{cacheName=" + this.cacheName + ", tombstone=" + this.tombstonesToRemove + '}';
    }

    public void add(IracTombstoneInfo tombstone) {
        this.tombstonesToRemove.add(tombstone);
    }

    public int size() {
        return this.tombstonesToRemove.size();
    }

    public boolean isEmpty() {
        return this.tombstonesToRemove.isEmpty();
    }

    public Collection<IracTombstoneInfo> getTombstonesToRemove() {
        return this.tombstonesToRemove;
    }
}

