/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.NONE)
public class FunctionMapper
implements Function {
    private final DataConversion keyDataConversion;
    private final DataConversion valueDataConversion;
    private final Function function;

    @Inject
    public void injectDependencies(ComponentRegistry registry) {
        registry.wireDependencies(this.keyDataConversion);
        registry.wireDependencies(this.valueDataConversion);
    }

    public FunctionMapper(Function mappingFunction, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        this.function = mappingFunction;
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
    }

    public Object apply(Object k) {
        Object key = this.keyDataConversion.fromStorage(k);
        Object result = this.function.apply(key);
        return result != null ? this.valueDataConversion.toStorage(result) : null;
    }

    public static class Externalizer
    implements AdvancedExternalizer<FunctionMapper> {
        @Override
        public Set<Class<? extends FunctionMapper>> getTypeClasses() {
            return Collections.singleton(FunctionMapper.class);
        }

        @Override
        public Integer getId() {
            return 125;
        }

        @Override
        public void writeObject(ObjectOutput output, FunctionMapper object) throws IOException {
            output.writeObject(object.function);
            DataConversion.writeTo(output, object.keyDataConversion);
            DataConversion.writeTo(output, object.valueDataConversion);
        }

        @Override
        public FunctionMapper readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new FunctionMapper((Function)input.readObject(), DataConversion.readFrom(input), DataConversion.readFrom(input));
        }
    }
}

