/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.util.Date;
import org.hl7.fhir.utilities.TranslationServices;

public class TranslatingUtilities {
    private TranslationServices translator;

    public TranslationServices getTranslator() {
        return this.translator;
    }

    public void setTranslator(TranslationServices translator) {
        this.translator = translator;
    }

    protected String translate(String context, String value) {
        return this.hasTranslator() ? this.translator.translate(context, value) : value;
    }

    protected boolean hasTranslator() {
        return this.translator != null;
    }

    public String toStr(int value) {
        return this.hasTranslator() ? this.translator.toStr(value) : Integer.toString(value);
    }

    public String toStr(Date value) {
        return this.hasTranslator() ? this.translator.toStr(value) : value.toString();
    }

    public String translate(String context, String value, Object ... args2) {
        String alt;
        if (this.hasTranslator() && (alt = this.translator.translate(context, value)) != null) {
            value = alt;
        }
        return String.format(value, args2);
    }
}

