/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SearchEntryMode {
    MATCH,
    INCLUDE,
    OUTCOME,
    NULL;


    public static SearchEntryMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("match".equals(codeString)) {
            return MATCH;
        }
        if ("include".equals(codeString)) {
            return INCLUDE;
        }
        if ("outcome".equals(codeString)) {
            return OUTCOME;
        }
        throw new FHIRException("Unknown SearchEntryMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MATCH: {
                return "match";
            }
            case INCLUDE: {
                return "include";
            }
            case OUTCOME: {
                return "outcome";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/search-entry-mode";
    }

    public String getDefinition() {
        switch (this) {
            case MATCH: {
                return "This resource matched the search specification.";
            }
            case INCLUDE: {
                return "This resource is returned because it is referred to from another resource in the search set.";
            }
            case OUTCOME: {
                return "An OperationOutcome that provides additional information about the processing of a search.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MATCH: {
                return "Match";
            }
            case INCLUDE: {
                return "Include";
            }
            case OUTCOME: {
                return "Outcome";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

