/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum RequestStatus {
    DRAFT,
    ACTIVE,
    ONHOLD,
    REVOKED,
    COMPLETED,
    ENTEREDINERROR,
    UNKNOWN,
    NULL;


    public static RequestStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("on-hold".equals(codeString)) {
            return ONHOLD;
        }
        if ("revoked".equals(codeString)) {
            return REVOKED;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown RequestStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case ACTIVE: {
                return "active";
            }
            case ONHOLD: {
                return "on-hold";
            }
            case REVOKED: {
                return "revoked";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case UNKNOWN: {
                return "unknown";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/request-status";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "The request has been created but is not yet complete or ready for action.";
            }
            case ACTIVE: {
                return "The request is in force and ready to be acted upon.";
            }
            case ONHOLD: {
                return "The request (and any implicit authorization to act) has been temporarily withdrawn but is expected to resume in the future.";
            }
            case REVOKED: {
                return "The request (and any implicit authorization to act) has been terminated prior to the known full completion of the intended actions.  No further activity should occur.";
            }
            case COMPLETED: {
                return "The activity described by the request has been fully performed.  No further activity will occur.";
            }
            case ENTEREDINERROR: {
                return "This request should never have existed and should be considered 'void'.  (It is possible that real-world decisions were based on it.  If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".).";
            }
            case UNKNOWN: {
                return "The authoring/source system does not know which of the status values currently applies for this request.  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply,  but the authoring/source system does not know which.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "Draft";
            }
            case ACTIVE: {
                return "Active";
            }
            case ONHOLD: {
                return "On Hold";
            }
            case REVOKED: {
                return "Revoked";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case UNKNOWN: {
                return "Unknown";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

