/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableRepeatWhen;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import io.reactivex.rxjava3.subscribers.SerializedSubscriber;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRetryWhen<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super Flowable<Throwable>, ? extends Publisher<?>> handler;

    public FlowableRetryWhen(Flowable<T> source2, Function<? super Flowable<Throwable>, ? extends Publisher<?>> handler) {
        super(source2);
        this.handler = handler;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s2) {
        Publisher<?> when;
        SerializedSubscriber<? super T> z = new SerializedSubscriber<T>(s2);
        FlowableProcessor<Throwable> processor = UnicastProcessor.create(8).toSerialized();
        try {
            when = Objects.requireNonNull(this.handler.apply(processor), "handler returned a null Publisher");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptySubscription.error(ex, s2);
            return;
        }
        FlowableRepeatWhen.WhenReceiver receiver = new FlowableRepeatWhen.WhenReceiver(this.source);
        RetryWhenSubscriber subscriber = new RetryWhenSubscriber(z, processor, (Subscription)receiver);
        receiver.subscriber = subscriber;
        s2.onSubscribe(subscriber);
        when.subscribe(receiver);
        receiver.onNext((Object)0);
    }

    static final class RetryWhenSubscriber<T>
    extends FlowableRepeatWhen.WhenSourceSubscriber<T, Throwable> {
        private static final long serialVersionUID = -2680129890138081029L;

        RetryWhenSubscriber(Subscriber<? super T> actual, FlowableProcessor<Throwable> processor, Subscription receiver) {
            super(actual, processor, receiver);
        }

        @Override
        public void onError(Throwable t) {
            this.again(t);
        }

        @Override
        public void onComplete() {
            this.receiver.cancel();
            this.downstream.onComplete();
        }
    }
}

