/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.fuseable.QueueSubscription;
import io.reactivex.rxjava3.internal.fuseable.SimpleQueue;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.QueueDrainHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowablePublishMulticast<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super Flowable<T>, ? extends Publisher<? extends R>> selector;
    final int prefetch;
    final boolean delayError;

    public FlowablePublishMulticast(Flowable<T> source2, Function<? super Flowable<T>, ? extends Publisher<? extends R>> selector, int prefetch, boolean delayError) {
        super(source2);
        this.selector = selector;
        this.prefetch = prefetch;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s2) {
        Publisher<R> other;
        MulticastProcessor mp = new MulticastProcessor(this.prefetch, this.delayError);
        try {
            other = Objects.requireNonNull(this.selector.apply(mp), "selector returned a null Publisher");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptySubscription.error(ex, s2);
            return;
        }
        OutputCanceller<? super R> out = new OutputCanceller<R>(s2, mp);
        other.subscribe(out);
        this.source.subscribe(mp);
    }

    static final class MulticastSubscription<T>
    extends AtomicLong
    implements Subscription {
        private static final long serialVersionUID = 8664815189257569791L;
        final Subscriber<? super T> downstream;
        final MulticastProcessor<T> parent;
        long emitted;

        MulticastSubscription(Subscriber<? super T> actual, MulticastProcessor<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.addCancel(this, n);
                this.parent.drain();
            }
        }

        @Override
        public void cancel() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
                this.parent.drain();
            }
        }

        public boolean isCancelled() {
            return this.get() == Long.MIN_VALUE;
        }
    }

    static final class MulticastProcessor<T>
    extends Flowable<T>
    implements FlowableSubscriber<T> {
        static final MulticastSubscription[] EMPTY = new MulticastSubscription[0];
        static final MulticastSubscription[] TERMINATED = new MulticastSubscription[0];
        final AtomicInteger wip;
        final AtomicReference<MulticastSubscription<T>[]> subscribers;
        final int prefetch;
        final int limit;
        final boolean delayError;
        final AtomicReference<Subscription> upstream;
        volatile SimpleQueue<T> queue;
        int sourceMode;
        volatile boolean done;
        Throwable error;
        int consumed;

        MulticastProcessor(int prefetch, boolean delayError) {
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.delayError = delayError;
            this.wip = new AtomicInteger();
            this.upstream = new AtomicReference();
            this.subscribers = new AtomicReference<MulticastSubscription[]>(EMPTY);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.setOnce(this.upstream, s2)) {
                if (s2 instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s2;
                    int m3 = qs.requestFusion(3);
                    if (m3 == 1) {
                        this.sourceMode = m3;
                        this.queue = qs;
                        this.done = true;
                        this.drain();
                        return;
                    }
                    if (m3 == 2) {
                        this.sourceMode = m3;
                        this.queue = qs;
                        QueueDrainHelper.request(s2, this.prefetch);
                        return;
                    }
                }
                this.queue = QueueDrainHelper.createQueue(this.prefetch);
                QueueDrainHelper.request(s2, this.prefetch);
            }
        }

        void dispose() {
            if (!this.done) {
                SimpleQueue<T> q;
                SubscriptionHelper.cancel(this.upstream);
                if (this.wip.getAndIncrement() == 0 && (q = this.queue) != null) {
                    q.clear();
                }
            }
        }

        boolean isDisposed() {
            return this.upstream.get() == SubscriptionHelper.CANCELLED;
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 0 && !this.queue.offer(t)) {
                this.upstream.get().cancel();
                this.onError(new MissingBackpressureException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.drain();
            }
        }

        boolean add(MulticastSubscription<T> s2) {
            MulticastSubscription[] next;
            MulticastSubscription<T>[] current;
            do {
                if ((current = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int n = current.length;
                next = new MulticastSubscription[n + 1];
                System.arraycopy(current, 0, next, 0, n);
                next[n] = s2;
            } while (!this.subscribers.compareAndSet(current, next));
            return true;
        }

        void remove(MulticastSubscription<T> s2) {
            MulticastSubscription[] next;
            MulticastSubscription<T>[] current;
            do {
                int n;
                if ((n = (current = this.subscribers.get()).length) == 0) {
                    return;
                }
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (current[i] != s2) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    next = EMPTY;
                    continue;
                }
                next = new MulticastSubscription[n - 1];
                System.arraycopy(current, 0, next, 0, j);
                System.arraycopy(current, j + 1, next, j, n - j - 1);
            } while (!this.subscribers.compareAndSet(current, next));
        }

        @Override
        protected void subscribeActual(Subscriber<? super T> s2) {
            MulticastSubscription<T> ms = new MulticastSubscription<T>(s2, this);
            s2.onSubscribe(ms);
            if (this.add(ms)) {
                if (ms.isCancelled()) {
                    this.remove(ms);
                    return;
                }
                this.drain();
            } else {
                Throwable ex = this.error;
                if (ex != null) {
                    s2.onError(ex);
                } else {
                    s2.onComplete();
                }
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SimpleQueue<T> q = this.queue;
            int upstreamConsumed = this.consumed;
            int localLimit = this.limit;
            boolean canRequest = this.sourceMode != 1;
            AtomicReference<MulticastSubscription<T>[]> subs = this.subscribers;
            MulticastSubscription<T>[] array = subs.get();
            block2: while (true) {
                int n = array.length;
                if (q != null && n != 0) {
                    long r = Long.MAX_VALUE;
                    for (MulticastSubscription<T> ms : array) {
                        long u = ms.get() - ms.emitted;
                        if (u != Long.MIN_VALUE) {
                            if (r <= u) continue;
                            r = u;
                            continue;
                        }
                        --n;
                    }
                    if (n == 0) {
                        r = 0L;
                    }
                    while (r != 0L) {
                        boolean empty;
                        T v;
                        Throwable ex;
                        if (this.isDisposed()) {
                            q.clear();
                            return;
                        }
                        boolean d = this.done;
                        if (d && !this.delayError && (ex = this.error) != null) {
                            this.errorAll(ex);
                            return;
                        }
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex2) {
                            Exceptions.throwIfFatal(ex2);
                            SubscriptionHelper.cancel(this.upstream);
                            this.errorAll(ex2);
                            return;
                        }
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            Throwable ex3 = this.error;
                            if (ex3 != null) {
                                this.errorAll(ex3);
                            } else {
                                this.completeAll();
                            }
                            return;
                        }
                        if (empty) break;
                        boolean subscribersChange = false;
                        for (MulticastSubscription<T> ms : array) {
                            long msr = ms.get();
                            if (msr != Long.MIN_VALUE) {
                                if (msr != Long.MAX_VALUE) {
                                    ++ms.emitted;
                                }
                                ms.downstream.onNext(v);
                                continue;
                            }
                            subscribersChange = true;
                        }
                        --r;
                        if (canRequest && ++upstreamConsumed == localLimit) {
                            upstreamConsumed = 0;
                            this.upstream.get().request(localLimit);
                        }
                        MulticastSubscription<T>[] freshArray = subs.get();
                        if (!subscribersChange && freshArray == array) continue;
                        array = freshArray;
                        continue block2;
                    }
                    if (r == 0L) {
                        Throwable ex;
                        if (this.isDisposed()) {
                            q.clear();
                            return;
                        }
                        boolean d = this.done;
                        if (d && !this.delayError && (ex = this.error) != null) {
                            this.errorAll(ex);
                            return;
                        }
                        if (d && q.isEmpty()) {
                            ex = this.error;
                            if (ex != null) {
                                this.errorAll(ex);
                            } else {
                                this.completeAll();
                            }
                            return;
                        }
                    }
                }
                this.consumed = upstreamConsumed;
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
                if (q == null) {
                    q = this.queue;
                }
                array = subs.get();
            }
        }

        void errorAll(Throwable ex) {
            for (MulticastSubscription ms : this.subscribers.getAndSet(TERMINATED)) {
                if (ms.get() == Long.MIN_VALUE) continue;
                ms.downstream.onError(ex);
            }
        }

        void completeAll() {
            for (MulticastSubscription ms : this.subscribers.getAndSet(TERMINATED)) {
                if (ms.get() == Long.MIN_VALUE) continue;
                ms.downstream.onComplete();
            }
        }
    }

    static final class OutputCanceller<R>
    implements FlowableSubscriber<R>,
    Subscription {
        final Subscriber<? super R> downstream;
        final MulticastProcessor<?> processor;
        Subscription upstream;

        OutputCanceller(Subscriber<? super R> actual, MulticastProcessor<?> processor) {
            this.downstream = actual;
            this.processor = processor;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(R t) {
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
            this.processor.dispose();
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
            this.processor.dispose();
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.processor.dispose();
        }
    }
}

