/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.client.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.client.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.ParametersUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationMethodBinding
extends BaseResourceReturningMethodBinding {
    private static final Logger ourLog = LoggerFactory.getLogger(OperationMethodBinding.class);
    private final boolean myIdempotent;
    private final Integer myIdParamIndex;
    private final String myName;
    private final RestOperationTypeEnum myOtherOperationType;
    private final BaseResourceReturningMethodBinding.ReturnTypeEnum myReturnType;
    private BundleTypeEnum myBundleType;
    private String myDescription;

    protected OperationMethodBinding(Class<?> theReturnResourceType, Class<? extends IBaseResource> theReturnTypeFromRp, Method theMethod, FhirContext theContext, Object theProvider, boolean theIdempotent, String theOperationName, Class<? extends IBaseResource> theOperationType, BundleTypeEnum theBundleType) {
        super(theReturnResourceType, theMethod, theContext, theProvider);
        this.myBundleType = theBundleType;
        this.myIdempotent = theIdempotent;
        this.myIdParamIndex = ParameterUtil.findIdParameterIndex(theMethod, this.getContext());
        Description description = theMethod.getAnnotation(Description.class);
        if (description != null) {
            this.myDescription = ParametersUtil.extractDescription(description);
        }
        if (StringUtils.isBlank(this.myDescription)) {
            this.myDescription = null;
        }
        if (StringUtils.isBlank((CharSequence)theOperationName)) {
            throw new ConfigurationException(Msg.code(1452) + "Method '" + theMethod.getName() + "' on type " + theMethod.getDeclaringClass().getName() + " is annotated with @" + Operation.class.getSimpleName() + " but this annotation has no name defined");
        }
        if (!((String)theOperationName).startsWith("$")) {
            theOperationName = "$" + (String)theOperationName;
        }
        this.myName = theOperationName;
        if (theReturnTypeFromRp != null) {
            this.setResourceName(theContext.getResourceType(theReturnTypeFromRp));
        } else if (!Modifier.isAbstract(theOperationType.getModifiers())) {
            this.setResourceName(theContext.getResourceType(theOperationType));
        } else {
            this.setResourceName(null);
        }
        this.myReturnType = BaseResourceReturningMethodBinding.ReturnTypeEnum.RESOURCE;
        this.myOtherOperationType = this.getResourceName() == null ? RestOperationTypeEnum.EXTENDED_OPERATION_SERVER : (this.myIdParamIndex == null ? RestOperationTypeEnum.EXTENDED_OPERATION_TYPE : RestOperationTypeEnum.EXTENDED_OPERATION_INSTANCE);
    }

    public OperationMethodBinding(Class<?> theReturnResourceType, Class<? extends IBaseResource> theReturnTypeFromRp, Method theMethod, FhirContext theContext, Object theProvider, Operation theAnnotation) {
        this(theReturnResourceType, theReturnTypeFromRp, theMethod, theContext, theProvider, theAnnotation.idempotent(), theAnnotation.name(), theAnnotation.type(), theAnnotation.bundleType());
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String theDescription) {
        this.myDescription = theDescription;
    }

    public String getName() {
        return this.myName;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return this.myBundleType;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return this.myOtherOperationType;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return this.myReturnType;
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        String id = null;
        if (this.myIdParamIndex != null) {
            IIdType idDt = (IIdType)theArgs[this.myIdParamIndex];
            id = idDt.getValue();
        }
        IBaseParameters parameters = (IBaseParameters)this.getContext().getResourceDefinition("Parameters").newInstance();
        if (theArgs != null) {
            for (int idx = 0; idx < theArgs.length; ++idx) {
                IParameter nextParam = this.getParameters().get(idx);
                nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, parameters);
            }
        }
        return OperationMethodBinding.createOperationInvocation(this.getContext(), this.getResourceName(), id, null, this.myName, parameters, false);
    }

    public boolean isIdempotent() {
        return this.myIdempotent;
    }

    public static BaseHttpClientInvocation createOperationInvocation(FhirContext theContext, String theResourceName, String theId, String theVersion, String theOperationName, IBaseParameters theInput, boolean theUseHttpGet) {
        StringBuilder b = new StringBuilder();
        if (theResourceName != null) {
            b.append(theResourceName);
            if (StringUtils.isNotBlank(theId)) {
                b.append('/');
                b.append(theId);
                if (StringUtils.isNotBlank(theVersion)) {
                    b.append("/_history/");
                    b.append(theVersion);
                }
            }
        }
        if (b.length() > 0) {
            b.append('/');
        }
        if (!theOperationName.startsWith("$")) {
            b.append("$");
        }
        b.append(theOperationName);
        if (!theUseHttpGet) {
            return new HttpPostClientInvocation(theContext, theInput, b.toString());
        }
        FhirTerser t = theContext.newTerser();
        List<IBase> parameters = t.getValues(theInput, "Parameters.parameter");
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        for (IBase nextParameter : parameters) {
            IBaseDatatype value;
            IPrimitiveType nextNameDt = (IPrimitiveType)t.getSingleValueOrNull(nextParameter, "name");
            if (nextNameDt == null || nextNameDt.isEmpty()) {
                ourLog.warn("Ignoring input parameter with no value in Parameters.parameter.name in operation client invocation");
                continue;
            }
            String nextName = nextNameDt.getValueAsString();
            if (!params.containsKey(nextName)) {
                params.put(nextName, new ArrayList());
            }
            if ((value = (IBaseDatatype)t.getSingleValueOrNull(nextParameter, "value[x]")) == null) continue;
            if (!(value instanceof IPrimitiveType)) {
                throw new IllegalArgumentException(Msg.code(1453) + "Can not invoke operation as HTTP GET when it has parameters with a composite (non priitive) datatype as the value. Found value: " + value.getClass().getName());
            }
            IPrimitiveType primitive = (IPrimitiveType)value;
            ((List)params.get(nextName)).add(primitive.getValueAsString());
        }
        return new HttpGetClientInvocation(theContext, params, b.toString());
    }

    public static BaseHttpClientInvocation createProcessMsgInvocation(FhirContext theContext, String theOperationName, IBaseBundle theInput, Map<String, List<String>> urlParams) {
        StringBuilder b = new StringBuilder();
        if (b.length() > 0) {
            b.append('/');
        }
        if (!theOperationName.startsWith("$")) {
            b.append("$");
        }
        b.append(theOperationName);
        BaseHttpClientInvocation.appendExtraParamsWithQuestionMark(urlParams, b, b.indexOf("?") == -1);
        return new HttpPostClientInvocation(theContext, theInput, b.toString());
    }
}

