/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;

public class RuntimeChildExt
extends BaseRuntimeChildDefinition {
    private Map<String, BaseRuntimeElementDefinition<?>> myNameToChild;
    private Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> myDatatypeToChild;
    private Map<Class<? extends IBase>, String> myDatatypeToChildName;

    @Override
    public BaseRuntimeChildDefinition.IAccessor getAccessor() {
        return new BaseRuntimeChildDefinition.IAccessor(){

            @Override
            public List<IBase> getValues(IBase theTarget) {
                List<? extends IBaseExtension<?, ?>> extension = ((IBaseHasExtensions)theTarget).getExtension();
                return Collections.unmodifiableList(extension);
            }
        };
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildByName(String theName) {
        return this.myNameToChild.get(theName);
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildElementDefinitionByDatatype(Class<? extends IBase> theType) {
        return this.myDatatypeToChild.get(theType);
    }

    @Override
    public String getChildNameByDatatype(Class<? extends IBase> theDatatype) {
        return this.myDatatypeToChildName.get(theDatatype);
    }

    @Override
    public String getElementName() {
        return "extension";
    }

    @Override
    public int getMax() {
        return -1;
    }

    @Override
    public int getMin() {
        return 0;
    }

    @Override
    public BaseRuntimeChildDefinition.IMutator getMutator() {
        return new BaseRuntimeChildDefinition.IMutator(){

            @Override
            public void addValue(IBase theTarget, IBase theValue) {
                List<IBaseExtension<?, ?>> extensions = ((IBaseHasExtensions)theTarget).getExtension();
                IBaseExtension value = (IBaseExtension)theValue;
                extensions.add(value);
            }

            @Override
            public void setValue(IBase theTarget, IBase theValue) {
                List<IBaseExtension<?, ?>> extensions = ((IBaseHasExtensions)theTarget).getExtension();
                extensions.clear();
                if (theValue != null) {
                    IBaseExtension value = (IBaseExtension)theValue;
                    extensions.add(value);
                }
            }
        };
    }

    @Override
    public Set<String> getValidChildNames() {
        return Sets.newHashSet("extension");
    }

    @Override
    public boolean isSummary() {
        return false;
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        this.myNameToChild = new HashMap();
        this.myDatatypeToChild = new HashMap();
        this.myDatatypeToChildName = new HashMap<Class<? extends IBase>, String>();
        for (BaseRuntimeElementDefinition<?> next : theClassToElementDefinitions.values()) {
            if (!next.getName().equals("Extension")) continue;
            this.myNameToChild.put("extension", next);
            this.myDatatypeToChild.put(next.getImplementingClass(), next);
            this.myDatatypeToChildName.put(next.getImplementingClass(), "extension");
        }
        Validate.isTrue(!this.myNameToChild.isEmpty());
    }
}

