/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.utilities;

import au.csiro.pathling.utilities.Preconditions;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.curator.utils.CloseableUtils;

public interface ObjectHolder<C extends Serializable, V> {
    public V getOrCreate(@Nonnull C var1);

    public void reset();

    public static <C extends Serializable, V> ObjectHolder<C, V> singleton(@Nonnull Function<C, V> constructor) {
        return new SingletonHolder<C, V>(constructor);
    }

    public static class SingletonHolder<C extends Serializable, V>
    implements ObjectHolder<C, V> {
        @Nonnull
        final Function<C, V> constructor;
        @Nullable
        private C configuration;
        @Nullable
        private V instance;

        private SingletonHolder(@Nonnull Function<C, V> constructor) {
            this.constructor = constructor;
        }

        @Override
        @Nonnull
        public synchronized V getOrCreate(@Nonnull C config) {
            if (this.configuration == null) {
                this.instance = this.constructor.apply(config);
                this.configuration = config;
            } else {
                Preconditions.check(this.configuration.equals(config), "Attempt to create SingletonHolder with different configuration", new Object[0]);
            }
            return Objects.requireNonNull(this.instance);
        }

        @Override
        public synchronized void reset() {
            if (this.instance instanceof Closeable) {
                CloseableUtils.closeQuietly((Closeable)((Closeable)this.instance));
                this.instance = null;
                this.configuration = null;
            }
        }
    }
}

