/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology;

import au.csiro.pathling.fhir.TerminologyClient;
import au.csiro.pathling.fhirpath.encoding.ImmutableCoding;
import au.csiro.pathling.terminology.BaseTerminologyService;
import au.csiro.pathling.terminology.TerminologyOperation;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.terminology.lookup.LookupExecutor;
import au.csiro.pathling.terminology.lookup.LookupParameters;
import au.csiro.pathling.terminology.subsumes.SubsumesExecutor;
import au.csiro.pathling.terminology.subsumes.SubsumesParameters;
import au.csiro.pathling.terminology.translate.TranslateExecutor;
import au.csiro.pathling.terminology.translate.TranslateParameters;
import au.csiro.pathling.terminology.validatecode.ValidateCodeExecutor;
import au.csiro.pathling.terminology.validatecode.ValidateCodeParameters;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInput;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.codesystems.ConceptSubsumptionOutcome;

public class DefaultTerminologyService
extends BaseTerminologyService {
    public DefaultTerminologyService(@Nonnull TerminologyClient terminologyClient, @Nullable Closeable toClose) {
        super(terminologyClient, toClose);
    }

    @Override
    public boolean validateCode(@Nonnull String valueSetUrl, @Nonnull Coding coding) {
        ValidateCodeParameters parameters = new ValidateCodeParameters(valueSetUrl, ImmutableCoding.of(coding));
        ValidateCodeExecutor executor = new ValidateCodeExecutor(this.terminologyClient, parameters);
        return Boolean.TRUE.equals(DefaultTerminologyService.execute(executor));
    }

    @Override
    @Nonnull
    public List<TerminologyService.Translation> translate(@Nonnull Coding coding, @Nonnull String conceptMapUrl, boolean reverse, @Nullable String target) {
        TranslateParameters parameters = new TranslateParameters(ImmutableCoding.of(coding), conceptMapUrl, reverse, target);
        TranslateExecutor executor = new TranslateExecutor(this.terminologyClient, parameters);
        return Objects.requireNonNull(DefaultTerminologyService.execute(executor));
    }

    @Override
    @Nonnull
    public ConceptSubsumptionOutcome subsumes(@Nonnull Coding codingA, @Nonnull Coding codingB) {
        SubsumesParameters parameters = new SubsumesParameters(ImmutableCoding.of(codingA), ImmutableCoding.of(codingB));
        SubsumesExecutor executor = new SubsumesExecutor(this.terminologyClient, parameters);
        return Objects.requireNonNull(DefaultTerminologyService.execute(executor));
    }

    @Override
    @Nonnull
    public List<TerminologyService.PropertyOrDesignation> lookup(@Nonnull Coding coding, @Nullable String property) {
        LookupParameters parameters = new LookupParameters(ImmutableCoding.of(coding), property);
        LookupExecutor executor = new LookupExecutor(this.terminologyClient, parameters);
        return Objects.requireNonNull(DefaultTerminologyService.execute(executor));
    }

    @Nullable
    private static <ResponseType, ResultType> ResultType execute(@Nonnull TerminologyOperation<ResponseType, ResultType> operation) {
        Optional<ResultType> invalidResult = operation.validate();
        if (invalidResult.isPresent()) {
            return invalidResult.get();
        }
        try {
            IOperationUntypedWithInput<ResponseType> request = operation.buildRequest();
            Object response = request.execute();
            return operation.extractResult(response);
        }
        catch (BaseServerResponseException e) {
            ResultType fallback = operation.invalidRequestFallback();
            return DefaultTerminologyService.handleError(e, fallback);
        }
    }
}

