/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.sql;

import au.csiro.pathling.sql.udf.TranslateUdf;
import au.csiro.pathling.utilities.Strings;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.hl7.fhir.r4.model.codesystems.ConceptMapEquivalence;

public interface TerminologySupport {
    @Nullable
    public static Set<ConceptMapEquivalence> parseCsvEquivalences(@Nullable String equivalencesCsv) {
        return Objects.isNull(equivalencesCsv) ? null : TerminologySupport.equivalenceCodesToEnum(Strings.parseCsvList(equivalencesCsv, Function.identity()));
    }

    @Nullable
    public static Set<ConceptMapEquivalence> equivalenceCodesToEnum(@Nullable Collection<String> equivalenceCodes) {
        return Objects.isNull(equivalenceCodes) ? null : equivalenceCodes.stream().map(TranslateUdf::checkValidEquivalenceCode).map(ConceptMapEquivalence::fromCode).collect(Collectors.toUnmodifiableSet());
    }
}

