/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.library;

import au.csiro.pathling.library.EncodeMapPartitions;
import au.csiro.pathling.support.FhirConversionSupport;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;

class EncodeBundleMapPartitions<T extends IBaseResource>
extends EncodeMapPartitions<T> {
    private static final long serialVersionUID = -4264073360143318480L;

    EncodeBundleMapPartitions(FhirVersionEnum fhirVersion, String inputMimeType, Class<T> resourceClass) {
        super(fhirVersion, inputMimeType, resourceClass);
    }

    @Override
    @Nonnull
    protected Stream<IBaseResource> processResources(@Nonnull Stream<IBaseResource> resources) {
        FhirConversionSupport conversionSupport = FhirConversionSupport.supportFor(this.fhirVersion);
        return resources.flatMap(maybeBundle -> conversionSupport.extractEntryFromBundle((IBaseBundle)maybeBundle, this.resourceClass).stream());
    }
}

