/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhirpath.encoding;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Coding;

public class ImmutableCoding
implements Serializable {
    private static final long serialVersionUID = -2461921559175440312L;
    @Nullable
    private final String system;
    @Nullable
    private final String version;
    @Nullable
    private final String code;
    @Nullable
    private final String display;
    @Nullable
    protected final Boolean userSelected;

    @Nonnull
    public Coding toCoding() {
        return new Coding(this.system, this.code, this.display).setVersion(this.version).setUserSelectedElement(this.userSelected != null ? new BooleanType(this.userSelected) : null);
    }

    @Nonnull
    public static ImmutableCoding of(@Nonnull Coding coding) {
        return ImmutableCoding.of(coding.getSystem(), coding.getVersion(), coding.getCode(), coding.getDisplay(), coding.hasUserSelected() ? Boolean.valueOf(coding.getUserSelected()) : null);
    }

    @Nonnull
    public static ImmutableCoding of(@Nonnull String system, @Nonnull String code, @Nonnull String display) {
        return ImmutableCoding.of(system, null, code, display, null);
    }

    @Nonnull
    public static ImmutableCoding empty() {
        return ImmutableCoding.of(null, null, null, null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableCoding that = (ImmutableCoding)o;
        return Objects.equals(this.system, that.system) && Objects.equals(this.version, that.version) && Objects.equals(this.code, that.code);
    }

    public int hashCode() {
        return Objects.hash(this.system, this.version, this.code);
    }

    private ImmutableCoding(@Nullable String system, @Nullable String version, @Nullable String code, @Nullable String display, @Nullable Boolean userSelected) {
        this.system = system;
        this.version = version;
        this.code = code;
        this.display = display;
        this.userSelected = userSelected;
    }

    public static ImmutableCoding of(@Nullable String system, @Nullable String version, @Nullable String code, @Nullable String display, @Nullable Boolean userSelected) {
        return new ImmutableCoding(system, version, code, display, userSelected);
    }

    public String toString() {
        return "ImmutableCoding(system=" + this.getSystem() + ", version=" + this.getVersion() + ", code=" + this.getCode() + ", display=" + this.getDisplay() + ", userSelected=" + this.getUserSelected() + ")";
    }

    @Nullable
    public String getSystem() {
        return this.system;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getCode() {
        return this.code;
    }

    @Nullable
    public String getDisplay() {
        return this.display;
    }

    @Nullable
    public Boolean getUserSelected() {
        return this.userSelected;
    }
}

