/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhir;

import au.csiro.pathling.fhir.TerminologyClient;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInput;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.ValueSet;

class DefaultTerminologyClient
implements TerminologyClient {
    @Nonnull
    final IGenericClient fhirClient;

    DefaultTerminologyClient(@Nonnull IGenericClient fhirClient) {
        this.fhirClient = fhirClient;
    }

    @Override
    @Nonnull
    public Parameters validateCode(@Nonnull UriType url, @Nonnull UriType system, @Nullable StringType version, @Nonnull CodeType code) {
        return (Parameters)this.buildValidateCode(url, system, version, code).execute();
    }

    @Override
    @Nonnull
    public IOperationUntypedWithInput<Parameters> buildValidateCode(@Nonnull UriType url, @Nonnull UriType system, @Nullable StringType version, @Nonnull CodeType code) {
        Parameters params = new Parameters();
        params.addParameter().setName("url").setValue(url);
        params.addParameter().setName("system").setValue(system);
        params.addParameter().setName("code").setValue(code);
        if (version != null) {
            params.addParameter().setName("systemVersion").setValue(version);
        }
        return ((IOperationUnnamed)this.fhirClient.operation().onType(ValueSet.class)).named("$validate-code").withParameters(params).useHttpGet();
    }

    @Override
    @Nonnull
    public Parameters translate(@Nonnull UriType url, @Nonnull UriType system, @Nullable StringType version, @Nonnull CodeType code, @Nullable BooleanType reverse, @Nullable UriType target) {
        return (Parameters)this.buildTranslate(url, system, version, code, reverse, target).execute();
    }

    @Override
    @Nonnull
    public IOperationUntypedWithInput<Parameters> buildTranslate(@Nonnull UriType url, @Nonnull UriType system, @Nullable StringType version, @Nonnull CodeType code, @Nullable BooleanType reverse, @Nullable UriType target) {
        Parameters params = new Parameters();
        params.addParameter().setName("url").setValue(url);
        params.addParameter().setName("system").setValue(system);
        params.addParameter().setName("code").setValue(code);
        if (version != null) {
            params.addParameter().setName("version").setValue(version);
        }
        if (reverse != null) {
            params.addParameter().setName("reverse").setValue(reverse);
        }
        if (target != null) {
            params.addParameter().setName("target").setValue(target);
        }
        return ((IOperationUnnamed)this.fhirClient.operation().onType(ConceptMap.class)).named("$translate").withParameters(params).useHttpGet();
    }

    @Override
    @Nonnull
    public Parameters subsumes(@Nonnull CodeType codeA, @Nonnull CodeType codeB, @Nonnull UriType system, @Nullable StringType version) {
        return (Parameters)this.buildSubsumes(codeA, codeB, system, version).execute();
    }

    @Override
    @Nonnull
    public IOperationUntypedWithInput<Parameters> buildSubsumes(@Nonnull CodeType codeA, @Nonnull CodeType codeB, @Nonnull UriType system, @Nullable StringType version) {
        Parameters params = new Parameters();
        params.addParameter().setName("codeA").setValue(codeA);
        params.addParameter().setName("codeB").setValue(codeB);
        params.addParameter().setName("system").setValue(system);
        if (version != null) {
            params.addParameter().setName("version").setValue(version);
        }
        return ((IOperationUnnamed)this.fhirClient.operation().onType(CodeSystem.class)).named("$subsumes").withParameters(params).useHttpGet();
    }

    @Override
    @Nonnull
    public Parameters lookup(@Nonnull UriType system, @Nullable StringType version, @Nonnull CodeType code, @Nullable CodeType property) {
        return (Parameters)this.buildLookup(system, version, code, property).execute();
    }

    @Override
    @Nonnull
    public IOperationUntypedWithInput<Parameters> buildLookup(@Nonnull UriType system, @Nullable StringType version, @Nonnull CodeType code, @Nullable CodeType property) {
        Parameters params = new Parameters();
        params.addParameter().setName("system").setValue(system);
        params.addParameter().setName("code").setValue(code);
        if (version != null) {
            params.addParameter().setName("version").setValue(version);
        }
        if (property != null) {
            params.addParameter().setName("property").setValue(property);
        }
        return ((IOperationUnnamed)this.fhirClient.operation().onType(CodeSystem.class)).named("$lookup").withParameters(params).useHttpGet();
    }
}

