import json
import setuptools

kwargs = json.loads("""
{
    "name": "aws-cdk.aws-stepfunctions-tasks",
    "version": "1.47.1",
    "description": "Task integrations for AWS StepFunctions",
    "license": "Apache-2.0",
    "url": "https://github.com/aws/aws-cdk",
    "long_description_content_type": "text/markdown",
    "author": "Amazon Web Services",
    "project_urls": {
        "Source": "https://github.com/aws/aws-cdk.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "aws_cdk.aws_stepfunctions_tasks",
        "aws_cdk.aws_stepfunctions_tasks._jsii"
    ],
    "package_data": {
        "aws_cdk.aws_stepfunctions_tasks._jsii": [
            "aws-stepfunctions-tasks@1.47.1.jsii.tgz"
        ],
        "aws_cdk.aws_stepfunctions_tasks": [
            "py.typed"
        ]
    },
    "python_requires": ">=3.6",
    "install_requires": [
        "jsii>=1.7.0, <2.0.0",
        "publication>=0.0.3",
        "aws-cdk.assets==1.47.1",
        "aws-cdk.aws-batch==1.47.1",
        "aws-cdk.aws-cloudwatch==1.47.1",
        "aws-cdk.aws-dynamodb==1.47.1",
        "aws-cdk.aws-ec2==1.47.1",
        "aws-cdk.aws-ecr==1.47.1",
        "aws-cdk.aws-ecr-assets==1.47.1",
        "aws-cdk.aws-ecs==1.47.1",
        "aws-cdk.aws-glue==1.47.1",
        "aws-cdk.aws-iam==1.47.1",
        "aws-cdk.aws-kms==1.47.1",
        "aws-cdk.aws-lambda==1.47.1",
        "aws-cdk.aws-s3==1.47.1",
        "aws-cdk.aws-sns==1.47.1",
        "aws-cdk.aws-sqs==1.47.1",
        "aws-cdk.aws-stepfunctions==1.47.1",
        "aws-cdk.core==1.47.1",
        "constructs>=3.0.2, <4.0.0"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Typing :: Typed",
        "Development Status :: 4 - Beta",
        "License :: OSI Approved"
    ]
}
""")

with open('README.md') as fp:
    kwargs['long_description'] = fp.read()


setuptools.setup(**kwargs)
