"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const tasks = require("../lib");
/*
 * Stack verification steps:
 * * aws stepfunctions start-execution --input '{"a": 3, "b": 4}' --state-machine-arn <StateMachineARN>
 * * aws stepfunctions describe-execution --execution-arn <execution-arn>
 * * The output here should contain `status: "SUCCEEDED"` and `output: "{ a: 3, b: 4, c: 7, d: 14, now: <current date> }"
 */
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-stepfunctions-integ');
const sum = new sfn.Task(stack, 'Sum', {
    task: new tasks.EvaluateExpression({
        expression: '$.a + $.b',
    }),
    resultPath: '$.c',
});
const multiply = new sfn.Task(stack, 'Multiply', {
    task: new tasks.EvaluateExpression({
        expression: '$.c * 2',
    }),
    resultPath: '$.d',
});
const now = new sfn.Task(stack, 'Now', {
    task: new tasks.EvaluateExpression({
        expression: '(new Date()).toUTCString()',
    }),
    resultPath: '$.now',
});
const statemachine = new sfn.StateMachine(stack, 'StateMachine', {
    definition: sum
        .next(multiply)
        .next(new sfn.Wait(stack, 'Wait', {
        time: sfn.WaitTime.secondsPath('$.d'),
    }))
        .next(now),
});
new cdk.CfnOutput(stack, 'StateMachineARN', {
    value: statemachine.stateMachineArn,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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