"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const eval_nodejs10_x_handler_1 = require("../lib/eval-nodejs10.x-handler");
test('with numbers', async () => {
    // GIVEN
    const event = {
        expression: '$.a + $.b',
        expressionAttributeValues: {
            '$.a': 4,
            '$.b': 5,
        },
    };
    // THEN
    const evaluated = await eval_nodejs10_x_handler_1.handler(event);
    expect(evaluated).toBe(9);
});
test('with strings', async () => {
    // GIVEN
    const event = {
        expression: '`${$.a} ${$.b}`',
        expressionAttributeValues: {
            '$.a': 'Hello',
            '$.b': 'world!',
        },
    };
    // THEN
    const evaluated = await eval_nodejs10_x_handler_1.handler(event);
    expect(evaluated).toBe('Hello world!');
});
test('with lists', async () => {
    // GIVEN
    const event = {
        expression: '$.a.map(x => x * 2)',
        expressionAttributeValues: {
            '$.a': [1, 2, 3],
        },
    };
    // THEN
    const evaluated = await eval_nodejs10_x_handler_1.handler(event);
    expect(evaluated).toEqual([2, 4, 6]);
});
//# sourceMappingURL=data:application/json;base64,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