"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ddb = require("@aws-cdk/aws-dynamodb");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const tasks = require("../../lib");
let stack;
let table;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
    table = new ddb.Table(stack, 'my-table', {
        tableName: 'my-table',
        partitionKey: {
            name: 'name',
            type: ddb.AttributeType.STRING,
        },
    });
});
test('UpdateItem task', () => {
    // WHEN
    const task = new tasks.DynamoUpdateItem(stack, 'UpdateItem', {
        key: { SOME_KEY: tasks.DynamoAttributeValue.fromString('1234') },
        table,
        conditionExpression: 'ForumName <> :f and Subject <> :s',
        expressionAttributeNames: { OTHER_KEY: '#OK' },
        expressionAttributeValues: {
            ':val': tasks.DynamoAttributeValue.numberFromString(sfn.Data.stringAt('$.Item.TotalCount.N')),
        },
        returnConsumedCapacity: tasks.DynamoConsumedCapacity.TOTAL,
        returnItemCollectionMetrics: tasks.DynamoItemCollectionMetrics.SIZE,
        returnValues: tasks.DynamoReturnValues.ALL_NEW,
        updateExpression: 'SET TotalCount = TotalCount + :val',
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::dynamodb:updateItem',
                ],
            ],
        },
        End: true,
        Parameters: {
            Key: { SOME_KEY: { S: '1234' } },
            TableName: {
                Ref: 'mytable0324D45C',
            },
            ConditionExpression: 'ForumName <> :f and Subject <> :s',
            ExpressionAttributeNames: { OTHER_KEY: '#OK' },
            ExpressionAttributeValues: { ':val': { 'N.$': '$.Item.TotalCount.N' } },
            ReturnConsumedCapacity: 'TOTAL',
            ReturnItemCollectionMetrics: 'SIZE',
            ReturnValues: 'ALL_NEW',
            UpdateExpression: 'SET TotalCount = TotalCount + :val',
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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