"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ddb = require("@aws-cdk/aws-dynamodb");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const tasks = require("../../lib");
let stack;
let table;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
    table = new ddb.Table(stack, 'my-table', {
        tableName: 'my-table',
        partitionKey: {
            name: 'name',
            type: ddb.AttributeType.STRING,
        },
    });
});
test('GetItem task', () => {
    // WHEN
    const task = new tasks.DynamoGetItem(stack, 'GetItem', {
        key: {
            SOME_KEY: tasks.DynamoAttributeValue.fromString('1234'),
            OTHER_KEY: tasks.DynamoAttributeValue.fromNumber(4321),
        },
        table,
        consistentRead: true,
        expressionAttributeNames: { OTHER_KEY: '#OK' },
        projectionExpression: [
            new tasks.DynamoProjectionExpression().withAttribute('Messages').atIndex(1).withAttribute('Tags'),
            new tasks.DynamoProjectionExpression().withAttribute('ID'),
        ],
        returnConsumedCapacity: tasks.DynamoConsumedCapacity.TOTAL,
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::dynamodb:getItem',
                ],
            ],
        },
        End: true,
        Parameters: {
            Key: { SOME_KEY: { S: '1234' }, OTHER_KEY: { N: '4321' } },
            TableName: {
                Ref: 'mytable0324D45C',
            },
            ConsistentRead: true,
            ExpressionAttributeNames: { OTHER_KEY: '#OK' },
            ProjectionExpression: 'Messages[1].Tags,ID',
            ReturnConsumedCapacity: 'TOTAL',
        },
    });
});
test('supports tokens', () => {
    // WHEN
    const task = new tasks.DynamoGetItem(stack, 'GetItem', {
        key: {
            SOME_KEY: tasks.DynamoAttributeValue.fromString(sfn.Data.stringAt('$.partitionKey')),
            OTHER_KEY: tasks.DynamoAttributeValue.numberFromString(sfn.Data.stringAt('$.sortKey')),
        },
        table,
        consistentRead: true,
        expressionAttributeNames: { OTHER_KEY: sfn.Data.stringAt('$.otherKey') },
        projectionExpression: [
            new tasks.DynamoProjectionExpression().withAttribute('Messages').atIndex(1).withAttribute('Tags'),
            new tasks.DynamoProjectionExpression().withAttribute('ID'),
        ],
        returnConsumedCapacity: tasks.DynamoConsumedCapacity.TOTAL,
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::dynamodb:getItem',
                ],
            ],
        },
        End: true,
        Parameters: {
            // tslint:disable:object-literal-key-quotes
            Key: {
                SOME_KEY: { 'S.$': '$.partitionKey' },
                OTHER_KEY: { 'N.$': '$.sortKey' },
            },
            TableName: {
                Ref: 'mytable0324D45C',
            },
            ConsistentRead: true,
            ExpressionAttributeNames: { 'OTHER_KEY.$': '$.otherKey' },
            ProjectionExpression: 'Messages[1].Tags,ID',
            ReturnConsumedCapacity: 'TOTAL',
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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