"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ddb = require("@aws-cdk/aws-dynamodb");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const tasks = require("../../lib");
let stack;
let table;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
    table = new ddb.Table(stack, 'my-table', {
        tableName: 'my-table',
        partitionKey: {
            name: 'name',
            type: ddb.AttributeType.STRING,
        },
    });
});
test('DeleteItem task', () => {
    // WHEN
    const task = new tasks.DynamoDeleteItem(stack, 'DeleteItem', {
        key: { SOME_KEY: tasks.DynamoAttributeValue.fromString('1234') },
        table,
        conditionExpression: 'ForumName <> :f and Subject <> :s',
        expressionAttributeNames: { OTHER_KEY: '#OK' },
        expressionAttributeValues: {
            ':val': tasks.DynamoAttributeValue.numberFromString(sfn.Data.stringAt('$.Item.TotalCount.N')),
        },
        returnConsumedCapacity: tasks.DynamoConsumedCapacity.TOTAL,
        returnItemCollectionMetrics: tasks.DynamoItemCollectionMetrics.SIZE,
        returnValues: tasks.DynamoReturnValues.ALL_NEW,
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::dynamodb:deleteItem',
                ],
            ],
        },
        End: true,
        Parameters: {
            Key: { SOME_KEY: { S: '1234' } },
            TableName: {
                Ref: 'mytable0324D45C',
            },
            ConditionExpression: 'ForumName <> :f and Subject <> :s',
            ExpressionAttributeNames: { OTHER_KEY: '#OK' },
            ExpressionAttributeValues: { ':val': { 'N.$': '$.Item.TotalCount.N' } },
            ReturnConsumedCapacity: 'TOTAL',
            ReturnItemCollectionMetrics: 'SIZE',
            ReturnValues: 'ALL_NEW',
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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