"""Handy constants for common granularities/periods."""
from datetime import timedelta

MICRO_SECOND = timedelta(microseconds=1)
MILLI_SECOND = timedelta(milliseconds=1)
SECOND = timedelta(seconds=1)
MINUTE = timedelta(minutes=1)
HOUR = timedelta(hours=1)
DAY = timedelta(days=1)
WEEK = timedelta(days=7)
MONTH = timedelta(days=30)

JANUARY = timedelta(days=15)
FEBRUARY = timedelta(days=46)
MARCH = timedelta(days=74)
APRIL = timedelta(days=105)
MAY = timedelta(days=135)
JUNE = timedelta(days=166)
JULY = timedelta(days=196)
AUGUST = timedelta(days=227)
SEPTEMBER = timedelta(days=258)
OCTOBER = timedelta(days=288)
NOVEMBER = timedelta(days=319)
DECEMBER = timedelta(days=349)

MONDAY_MORNING = timedelta(hours=8, minutes=30)
MONDAY_LUNCHTIME = timedelta(hours=12, minutes=30)
MONDAY_EVENING = timedelta(hours=20)
MONDAY_NIGHT = timedelta(hours=23)
TUESDAY_MORNING = timedelta(days=1, hours=8, minutes=30)
TUESDAY_LUNCHTIME = timedelta(days=1, hours=12, minutes=30)
TUESDAY_EVENING = timedelta(days=1, hours=20)
TUESDAY_NIGHT = timedelta(days=2, hours=23)
WEDNESDAY_MORNING = timedelta(days=2, hours=8, minutes=30)
WEDNESDAY_LUNCHTIME = timedelta(days=2, hours=12, minutes=30)
WEDNESDAY_EVENING = timedelta(days=2, hours=20)
WEDNESDAY_NIGHT = timedelta(days=2, hours=23)
THURSDAY_MORNING = timedelta(days=3, hours=8, minutes=30)
THURSDAY_LUNCHTIME = timedelta(days=3, hours=12, minutes=30)
THURSDAY_EVENING = timedelta(days=3, hours=20)
THURSDAY_NIGHT = timedelta(days=3, hours=23)
FRIDAY_MORNING = timedelta(days=4, hours=8, minutes=30)
FRIDAY_LUNCHTIME = timedelta(days=4, hours=12, minutes=30)
FRIDAY_EVENING = timedelta(days=4, hours=20)
FRIDAY_NIGHT = timedelta(days=4, hours=23)
SATURDAY_MORNING = timedelta(days=5, hours=8, minutes=30)
SATURDAY_LUNCHTIME = timedelta(days=5, hours=12, minutes=30)
SATURDAY_EVENING = timedelta(days=5, hours=20)
SATURDAY_NIGHT = timedelta(days=5, hours=23)
SUNDAY_MORNING = timedelta(days=6, hours=8, minutes=30)
SUNDAY_LUNCHTIME = timedelta(days=6, hours=12, minutes=30)
SUNDAY_EVENING = timedelta(days=6, hours=20)
SUNDAY_NIGHT = timedelta(days=6, hours=23)
