"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientVpnRoute = exports.ClientVpnRouteTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const ec2_generated_1 = require("./ec2.generated");
/**
 * Target for a client VPN route.
 *
 * @stability stable
 */
class ClientVpnRouteTarget {
    /**
     * Subnet.
     *
     * The specified subnet must be an existing target network of the client VPN
     * endpoint.
     *
     * @stability stable
     */
    static subnet(subnet) {
        return { subnetId: subnet.subnetId };
    }
    /**
     * Local network.
     *
     * @stability stable
     */
    static local() {
        return { subnetId: 'local' };
    }
}
exports.ClientVpnRouteTarget = ClientVpnRouteTarget;
_a = JSII_RTTI_SYMBOL_1;
ClientVpnRouteTarget[_a] = { fqn: "@aws-cdk/aws-ec2.ClientVpnRouteTarget", version: "1.129.0" };
/**
 * A client VPN route.
 *
 * @stability stable
 */
class ClientVpnRoute extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        if (!props.clientVpnEndoint && !props.clientVpnEndpoint) {
            throw new Error('ClientVpnRoute: either clientVpnEndpoint or clientVpnEndoint (deprecated) must be specified');
        }
        if (props.clientVpnEndoint && props.clientVpnEndpoint) {
            throw new Error('ClientVpnRoute: either clientVpnEndpoint or clientVpnEndoint (deprecated) must be specified' +
                ', but not both');
        }
        const clientVpnEndpoint = props.clientVpnEndoint || props.clientVpnEndpoint;
        super(scope, id);
        const route = new ec2_generated_1.CfnClientVpnRoute(this, 'Resource', {
            clientVpnEndpointId: clientVpnEndpoint.endpointId,
            description: props.description,
            destinationCidrBlock: props.cidr,
            targetVpcSubnetId: props.target.subnetId,
        });
        // See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html
        route.node.addDependency(clientVpnEndpoint.targetNetworksAssociated);
    }
}
exports.ClientVpnRoute = ClientVpnRoute;
_b = JSII_RTTI_SYMBOL_1;
ClientVpnRoute[_b] = { fqn: "@aws-cdk/aws-ec2.ClientVpnRoute", version: "1.129.0" };
//# sourceMappingURL=data:application/json;base64,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