"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LaunchTemplateRequireImdsv2Aspect = exports.InstanceRequireImdsv2Aspect = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const ec2_generated_1 = require("../ec2.generated");
const instance_1 = require("../instance");
const launch_template_1 = require("../launch-template");
/**
 * Base class for Aspect that makes IMDSv2 required.
 */
class RequireImdsv2Aspect {
    constructor(props) {
        var _c;
        this.suppressWarnings = (_c = props === null || props === void 0 ? void 0 : props.suppressWarnings) !== null && _c !== void 0 ? _c : false;
    }
    /**
     * Adds a warning annotation to a node, unless `suppressWarnings` is true.
     *
     * @param node The scope to add the warning to.
     * @param message The warning message.
     * @stability stable
     */
    warn(node, message) {
        if (this.suppressWarnings !== true) {
            cdk.Annotations.of(node).addWarning(`${RequireImdsv2Aspect.name} failed on node ${node.node.id}: ${message}`);
        }
    }
}
/**
 * Aspect that applies IMDS configuration on EC2 Instance constructs.
 *
 * This aspect configures IMDS on an EC2 instance by creating a Launch Template with the
 * IMDS configuration and associating that Launch Template with the instance. If an Instance
 * is already associated with a Launch Template, a warning will (optionally) be added to the
 * construct node and it will be skipped.
 *
 * To cover Instances already associated with Launch Templates, use `LaunchTemplateImdsAspect`.
 *
 * @stability stable
 */
class InstanceRequireImdsv2Aspect extends RequireImdsv2Aspect {
    /**
     * @stability stable
     */
    constructor(props) {
        var _c;
        super(props);
        this.suppressLaunchTemplateWarning = (_c = props === null || props === void 0 ? void 0 : props.suppressLaunchTemplateWarning) !== null && _c !== void 0 ? _c : false;
    }
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(node) {
        if (!(node instanceof instance_1.Instance)) {
            return;
        }
        if (node.instance.launchTemplate !== undefined) {
            this.warn(node, 'Cannot toggle IMDSv1 because this Instance is associated with an existing Launch Template.');
            return;
        }
        const name = `${node.node.id}LaunchTemplate`;
        const launchTemplate = new ec2_generated_1.CfnLaunchTemplate(node, 'LaunchTemplate', {
            launchTemplateData: {
                metadataOptions: {
                    httpTokens: 'required',
                },
            },
            launchTemplateName: name,
        });
        node.instance.launchTemplate = {
            launchTemplateName: name,
            version: launchTemplate.getAtt('LatestVersionNumber').toString(),
        };
    }
    /**
     * Adds a warning annotation to a node, unless `suppressWarnings` is true.
     *
     * @stability stable
     */
    warn(node, message) {
        if (this.suppressLaunchTemplateWarning !== true) {
            super.warn(node, message);
        }
    }
}
exports.InstanceRequireImdsv2Aspect = InstanceRequireImdsv2Aspect;
_a = JSII_RTTI_SYMBOL_1;
InstanceRequireImdsv2Aspect[_a] = { fqn: "@aws-cdk/aws-ec2.InstanceRequireImdsv2Aspect", version: "1.129.0" };
/**
 * Aspect that applies IMDS configuration on EC2 Launch Template constructs.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html
 * @stability stable
 */
class LaunchTemplateRequireImdsv2Aspect extends RequireImdsv2Aspect {
    /**
     * @stability stable
     */
    constructor(props) {
        super(props);
    }
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(node) {
        if (!(node instanceof launch_template_1.LaunchTemplate)) {
            return;
        }
        const launchTemplate = node.node.tryFindChild('Resource');
        const data = launchTemplate.launchTemplateData;
        if (cdk.isResolvableObject(data)) {
            this.warn(node, 'LaunchTemplateData is a CDK token.');
            return;
        }
        const metadataOptions = data.metadataOptions;
        if (cdk.isResolvableObject(metadataOptions)) {
            this.warn(node, 'LaunchTemplateData.MetadataOptions is a CDK token.');
            return;
        }
        const newData = {
            ...data,
            metadataOptions: {
                ...metadataOptions,
                httpTokens: 'required',
            },
        };
        launchTemplate.launchTemplateData = newData;
    }
}
exports.LaunchTemplateRequireImdsv2Aspect = LaunchTemplateRequireImdsv2Aspect;
_b = JSII_RTTI_SYMBOL_1;
LaunchTemplateRequireImdsv2Aspect[_b] = { fqn: "@aws-cdk/aws-ec2.LaunchTemplateRequireImdsv2Aspect", version: "1.129.0" };
//# sourceMappingURL=data:application/json;base64,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