#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['stack_alert']

package_data = \
{'': ['*'], 'stack_alert': ['templates/*']}

install_requires = \
['appdirs',
 'docopt',
 'excerpt-html',
 'inform',
 'jinja2',
 'more_itertools',
 'requests',
 'toml',
 'tqdm']

extras_require = \
{'docs': ['sphinx', 'sphinx_rtd_theme', 'autoclasstoc'],
 'tests': ['pytest', 'pytest-cov', 'coveralls']}

entry_points = \
{'console_scripts': ['stack_alert = stack_alert.cli:main']}

setup(name='stack_alert',
      version='0.0.0',
      description='Be notified when interesting questions are posted to Stack Exchange sites.',
      author='Kale Kundert',
      author_email='kale@thekunderts.net',
      url='https://github.com/kalekundert/stack_alert',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='~=3.6',
     )
