# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.ucb
from typing_extensions import Literal
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .numbered_sorting_info import NumberedSortingInfo as NumberedSortingInfo_fd0e0de6
    from .x_any_compare_factory import XAnyCompareFactory as XAnyCompareFactory_ec090d61
    from .x_dynamic_result_set import XDynamicResultSet as XDynamicResultSet_e0360d0a

class XCachedDynamicResultSetStubFactory(XInterface_8f010a43):
    """
    creates a CachedDynamicResultSetStub and connects a non-remote optimized DynamicResultSet to a remote optimized CachedDynamicResultSet.
    
    Pay attention to instantiate this helper on server side where your source DynamicResultSet was instantiated.
    
    Method XCachedDynamicResultSetStubFactory.createCachedDynamicResultSetStub() can be used to create a stub on server side.
    
    If you have instantiated a CachedDynamicResultSet on client side already, use method connectToCache() to connect your given DynamicResultSet with this Cache.
    
    The needed cache on server side you can create using XCachedDynamicResultSetFactory.

    See Also:
        `API XCachedDynamicResultSetStubFactory <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1ucb_1_1XCachedDynamicResultSetStubFactory.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.ucb.XCachedDynamicResultSetStubFactory']

    def connectToCache(self, Source: 'XDynamicResultSet_e0360d0a', TargetCache: 'XDynamicResultSet_e0360d0a', SortingInfo: 'typing.Tuple[NumberedSortingInfo_fd0e0de6, ...]', CompareFactory: 'XAnyCompareFactory_ec090d61') -> None:
        """
        If you have instantiated a CachedDynamicResultSet on client side already, use this to connect your given Source on server side to the TargetCache.

        Raises:
            : ````
            com.sun.star.ucb.AlreadyInitializedException: ``AlreadyInitializedException``
        """
    def createCachedDynamicResultSetStub(self, Source: 'XDynamicResultSet_e0360d0a') -> 'XDynamicResultSet_e0360d0a':
        """
        creates a remote optimizes XDynamicResultSet.
        """

