# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.geometry
# Libre Office Version: 7.3
from typing_extensions import Literal
import typing


class RealBezierSegment2D(object):
    """
    Struct Class

    This structure contains the relevant data for a cubic Bezier curve.
    
    The data is stored real-valued. The last point of the segment is taken from the first point of the following segment, and thus not included herein. That is, when forming a polygon out of cubic Bezier segments, each two consecutive RealBezierSegment2D define the actual curve, with the very last segment providing only the end point of the last curve, and the remaining members ignored.
    
    **since**
    
        OOo 2.0

    See Also:
        `API RealBezierSegment2D <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1geometry_1_1RealBezierSegment2D.html>`_
    """
    typeName: Literal['com.sun.star.geometry.RealBezierSegment2D']

    def __init__(self, Px: typing.Optional[float] = ..., Py: typing.Optional[float] = ..., C1x: typing.Optional[float] = ..., C1y: typing.Optional[float] = ..., C2x: typing.Optional[float] = ..., C2y: typing.Optional[float] = ...) -> None:
        """
        Constructor

        Arguments:
            Px (float, optional): Px value.
            Py (float, optional): Py value.
            C1x (float, optional): C1x value.
            C1y (float, optional): C1y value.
            C2x (float, optional): C2x value.
            C2y (float, optional): C2y value.
        """


    @property
    def Px(self) -> float:
        """
        The x coordinate of the start point.
        """


    @property
    def Py(self) -> float:
        """
        The y coordinate of the start point.
        """


    @property
    def C1x(self) -> float:
        """
        The x coordinate of the first control point.
        """


    @property
    def C1y(self) -> float:
        """
        The y coordinate of the first control point.
        """


    @property
    def C2x(self) -> float:
        """
        The x coordinate of the second control point.
        """


    @property
    def C2y(self) -> float:
        """
        The y coordinate of the second control point.
        """


