# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.drawing
# Libre Office Version: 7.3
from typing_extensions import Literal
import typing
from .dash_style import DashStyle as DashStyle_b10d0b85


class LineDash(object):
    """
    Struct Class

    A LineDash defines a non-continuous line.

    See Also:
        `API LineDash <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1drawing_1_1LineDash.html>`_
    """
    typeName: Literal['com.sun.star.drawing.LineDash']

    def __init__(self, Style: typing.Optional[DashStyle_b10d0b85] = ..., Dots: typing.Optional[int] = ..., DotLen: typing.Optional[int] = ..., Dashes: typing.Optional[int] = ..., DashLen: typing.Optional[int] = ..., Distance: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            Style (DashStyle, optional): Style value.
            Dots (int, optional): Dots value.
            DotLen (int, optional): DotLen value.
            Dashes (int, optional): Dashes value.
            DashLen (int, optional): DashLen value.
            Distance (int, optional): Distance value.
        """


    @property
    def Style(self) -> DashStyle_b10d0b85:
        """
        This sets the style of this LineDash.
        """


    @property
    def Dots(self) -> int:
        """
        This is the number of dots in this LineDash.
        """


    @property
    def DotLen(self) -> int:
        """
        This is the length of a dot.
        """


    @property
    def Dashes(self) -> int:
        """
        This is the number of dashes.
        """


    @property
    def DashLen(self) -> int:
        """
        This is the length of a single dash.
        """


    @property
    def Distance(self) -> int:
        """
        This is the distance between the dots.
        """


