"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompliantDynamoDb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const backup = require("@aws-cdk/aws-backup");
const dynamodb = require("@aws-cdk/aws-dynamodb");
const aws_events_1 = require("@aws-cdk/aws-events");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * Creates a DynamoDB table that is secured by an AWS backup plan und with point in time recovery enabled by default.
 *
 * @stability stable
 */
class CompliantDynamoDb extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        this.dynamodbTable = new dynamodb.Table(this, 'DynamoDBTable', {
            tableName: props.tableName,
            billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
            partitionKey: (_b = props.partitionKey) !== null && _b !== void 0 ? _b : {
                name: 'id',
                type: dynamodb.AttributeType.STRING,
            },
            sortKey: props.sortKey,
            pointInTimeRecovery: props.configRuleList.DYNAMODB_PITR_ENABLED == true
                ? true
                : props.pointInTimeRecovery,
            encryption: props.configRuleList.DYNAMODB_TABLE_ENCRYPTED_KMS == true
                ? dynamodb.TableEncryption.CUSTOMER_MANAGED
                : props.encryption,
            encryptionKey: props.encryptionKey,
            contributorInsightsEnabled: props.contributorInsightsEnabled,
            kinesisStream: props.kinesisStream,
            replicationRegions: props.replicationRegions,
            replicationTimeout: props.replicationTimeout,
            timeToLiveAttribute: props.timeToLiveAttribute,
        });
        if (props.configRuleList.BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED ==
            true) {
            this.backupVault = new backup.BackupVault(this, 'BackupVault', {
                backupVaultName: `${props.tableName}-backup-vault`,
                accessPolicy: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            sid: 'backup-recovery-point-manual-deletion-disabled',
                            effect: iam.Effect.DENY,
                            principals: [new iam.AnyPrincipal()],
                            actions: [
                                'backup:DeleteRecoveryPoint',
                                'backup:PutBackupVaultAccessPolicy',
                                'backup:UpdateRecoveryPointLifecycle',
                            ],
                            resources: ['*'],
                        }),
                    ],
                }),
            });
        }
        else {
            this.backupVault = new backup.BackupVault(this, 'BackupVault', {
                backupVaultName: `${props.tableName}-backup-vault`,
            });
        }
        this.backupPlan = new backup.BackupPlan(this, 'DynamoDbBackupPlan', {
            backupPlanName: `${this.dynamodbTable.tableName}-backup-plan`,
            backupVault: this.backupVault,
            backupPlanRules: [
                new backup.BackupPlanRule({
                    ruleName: 'daily-dynamodb-backup',
                    scheduleExpression: (_c = props.backupPlanStartTime) !== null && _c !== void 0 ? _c : aws_events_1.Schedule.cron({
                        hour: '21',
                        minute: '0',
                    }),
                    deleteAfter: cdk.Duration.days(35),
                }),
            ],
        });
        this.backupPlan.addSelection('DynamoDB', {
            resources: [backup.BackupResource.fromDynamoDbTable(this.dynamodbTable)],
        });
    }
}
exports.CompliantDynamoDb = CompliantDynamoDb;
_a = JSII_RTTI_SYMBOL_1;
CompliantDynamoDb[_a] = { fqn: "compliantdynamodb.CompliantDynamoDb", version: "0.0.22" };
//# sourceMappingURL=data:application/json;base64,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