# ppfun by portasynthinca3
# distributed under WTFPL

import requests
import json
import datetime
import colorsys
import math

class PPFun_Exception(Exception):
    pass

# the canvas class
class PPFun_canv():
    ident_no = 0
    ident = ''
    title = ''
    colors = []
    desc = ''
    size = 0
    _cooldown = 0
    _cooldown_upd = datetime.datetime.now()

    # class constructor
    def __init__(self, desc, iid):
        self.ident_no = int(iid)
        self.ident = desc['ident']
        self.title = desc['title']
        self.desc = desc['desc']
        self.size = desc['size']
        # first two colors are ocean blue and land white
        # I have no idea of why do you need to duplicate them, especially
        #  if sending color numbers 0 and 1 causes an error, but okay
        self.colors = [(c[0], c[1], c[2]) for c in desc['colors']][2:]

    # returns the number of the most similar color
    def approx_color(self, rgb):
        best_color_id = 0
        best_color_diff = 1000
        (r, g, b) = rgb
        (y, i, q) = colorsys.rgb_to_yiq(r / 255, g / 255, b / 255)
        # go through the color list
        for c in self.colors:
            (cr, cg, cb) = c
            # convert the color to YIQ
            (cy, ci, cq) = colorsys.rgb_to_yiq(cr / 255, cg / 255, cb / 255)
            # calculate the difference
            diff = math.sqrt(1.0 * ((cy - y) ** 2)
                           + 1.0 * ((ci - i) ** 2)
                           + 1.0 * ((cq - q) ** 2))
            # if that difference is smaller than the current best one, choose it
            if diff < best_color_diff:
                best_color_diff = diff
                best_color_id = self.colors.index(c)
        return best_color_id + 2

    # sets a pixel on this canvas
    def set_pixel(self, pos, color):
        (x, y) = pos
        # make a request
        r = requests.post('https://pixelplanet.fun/api/pixel', data=json.dumps({
            'cn': self.ident_no,
            'x': x,
            'y': y,
            'clr': color,
            'token': None
        }), headers={
            'Accept': '*/*',
            'Content-Type': 'application/json'
        })
        # parse the response
        response = r.json()
        if 'errors' in response:
            for err in response['errors']:
                raise PPFun_Exception(err['msg'])
            return False
        if 'waitSeconds' in response:
            self._cooldown = response['waitSeconds']
            self._cooldown_upd = datetime.datetime.now()
            return True

    # returns the remaining cooldown time in seconds
    def remaining_cooldown(self):
        adjust = datetime.datetime.now() - self._cooldown_upd
        self._cooldown = self._cooldown - adjust.total_seconds()
        self._cooldown_upd = datetime.datetime.now()
        if self._cooldown < 0:
            self._cooldown = 0
        return self._cooldown

# the main class
class PPFun_api():
    json_canvases = {}
    name = ''

    # class constructor
    def __init__(self):
        # make an initial request
        me = requests.get('https://pixelplanet.fun/api/me').json()
        self.name = me['name']
        self.json_canvases = me['canvases']

    # returns a canvas object by its identifier
    def get_canv(self, ident):
        # go through the JSON canvas descriptions
        for k in self.json_canvases:
            c_json = self.json_canvases[k]
            c_ident = c_json['ident']
            # search for a specific identifier
            if c_ident == ident:
                return PPFun_canv(c_json, k)
        # no such canvases exist
        return None

    # returns a list of canvas identifiers, names, descriptions and sizes
    def list_canv(self):
        result = []
        # go through the JSON canvas descriptions
        for k in self.json_canvases:
            c_json = self.json_canvases[k]
            result.append({'identifier':  c_json['ident'],
                           'title':       c_json['title'],
                           'description': c_json['desc'],
                           'size':        c_json['size']})
        return result