# Generated by Django 2.2.11 on 2020-03-13 05:58

from django.db import migrations, models
import django.db.models.deletion
import mptt.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='FieldWidget',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field_type', models.CharField(max_length=64, verbose_name='Field Type')),
                ('name', models.CharField(max_length=64, verbose_name='Name')),
            ],
        ),
        migrations.CreateModel(
            name='ModelDefinition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, unique=True, verbose_name='Name')),
                ('verbose_name', models.CharField(max_length=64, verbose_name='Verbose Name')),
                ('title_template', models.CharField(blank=True, max_length=128, null=True, verbose_name='Title Template')),
                ('fieldsets_data', models.TextField(blank=True, null=True, verbose_name='Fieldsets Setting')),
            ],
        ),
        migrations.CreateModel(
            name='ModelFieldset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=64, null=True, verbose_name='Name')),
                ('fields', models.TextField(blank=True, null=True, verbose_name='Fields')),
                ('classes', models.CharField(blank=True, max_length=128, null=True, verbose_name='Classes')),
                ('order', models.IntegerField(default=0, verbose_name='Order')),
                ('definition', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fieldsets', to='django_dynamic_model_admin.ModelDefinition', verbose_name='Definition')),
            ],
            options={
                'verbose_name': 'Model Fieldset',
                'verbose_name_plural': 'Model Fieldsets',
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='ModelDefinitionCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64)),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='django_dynamic_model_admin.ModelDefinitionCategory', verbose_name='Model Definition Category Parent')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='modeldefinition',
            name='parent',
            field=mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='definitions', to='django_dynamic_model_admin.ModelDefinitionCategory', verbose_name='Model Definition Category'),
        ),
        migrations.CreateModel(
            name='Data',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True)),
                ('update_time', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(blank=True, max_length=128, null=True, verbose_name='Title')),
                ('c01', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c02', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c03', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c04', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c05', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c06', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c07', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c08', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c09', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c10', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c11', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c12', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c13', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c14', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c15', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c16', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c17', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c18', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c19', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('c20', models.CharField(blank=True, db_index=True, max_length=4096, null=True)),
                ('i01', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i02', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i03', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i04', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i05', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i06', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i07', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i08', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i09', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i10', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i11', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i12', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i13', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i14', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i15', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i16', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i17', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i18', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i19', models.IntegerField(blank=True, db_index=True, null=True)),
                ('i20', models.IntegerField(blank=True, db_index=True, null=True)),
                ('d01', models.DateTimeField(blank=True, db_index=True, null=True)),
                ('d02', models.DateTimeField(blank=True, db_index=True, null=True)),
                ('d03', models.DateTimeField(blank=True, db_index=True, null=True)),
                ('d04', models.DateTimeField(blank=True, db_index=True, null=True)),
                ('d05', models.DateTimeField(blank=True, db_index=True, null=True)),
                ('d06', models.DateTimeField(blank=True, db_index=True, null=True)),
                ('d07', models.DateTimeField(blank=True, db_index=True, null=True)),
                ('d08', models.DateTimeField(blank=True, db_index=True, null=True)),
                ('d09', models.DateTimeField(blank=True, db_index=True, null=True)),
                ('d10', models.DateTimeField(blank=True, db_index=True, null=True)),
                ('t01', models.TextField(blank=True, db_index=True, null=True)),
                ('t02', models.TextField(blank=True, db_index=True, null=True)),
                ('t03', models.TextField(blank=True, db_index=True, null=True)),
                ('t04', models.TextField(blank=True, db_index=True, null=True)),
                ('t05', models.TextField(blank=True, db_index=True, null=True)),
                ('t06', models.TextField(blank=True, db_index=True, null=True)),
                ('t07', models.TextField(blank=True, db_index=True, null=True)),
                ('t08', models.TextField(blank=True, db_index=True, null=True)),
                ('t09', models.TextField(blank=True, db_index=True, null=True)),
                ('t10', models.TextField(blank=True, db_index=True, null=True)),
                ('md', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='data', to='django_dynamic_model_admin.ModelDefinition', verbose_name='Model Definition')),
            ],
        ),
        migrations.CreateModel(
            name='ModelField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('real_field_name', models.CharField(max_length=64, verbose_name='Real Field Name')),
                ('field_type', models.CharField(blank=True, max_length=64, null=True, verbose_name='Field Type')),
                ('verbose_name', models.CharField(blank=True, max_length=64, null=True, verbose_name='Verbose Name')),
                ('prefered_field_name', models.CharField(blank=True, max_length=64, null=True, verbose_name='Prefered Field Name')),
                ('help_text', models.CharField(blank=True, max_length=512, null=True, verbose_name='Help Text')),
                ('definition', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fields', to='django_dynamic_model_admin.ModelDefinition', verbose_name='Definition')),
                ('field_widget', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='django_dynamic_model_admin.FieldWidget', verbose_name='Field Widget')),
            ],
            options={
                'unique_together': {('definition', 'prefered_field_name'), ('definition', 'real_field_name')},
            },
        ),
    ]
