
# -*- coding: utf-8 -*-

# ===================================================================
# The contents of this file are dedicated to the public domain.  To
# the extent that dedication to the public domain is not available,
# everyone is granted a worldwide, perpetual, royalty-free,
# non-exclusive license to exercise all rights associated with the
# contents of this file for any purpose whatsoever.
# KaisaGlobal rights are reserved.
# Technical index data
# ===================================================================
import sys
from os.path import dirname, abspath
import requests, datetime
import pandas as pd
import numpy as np
import json
from common.com import *
from pub_cls_com import *
'''Date: 2021.03.16'''

def _handle_ex_ret(code_list=['00700'], queryType=None, start_date=None, end_date=None, market=2, unit='1d', page=1, fre=2):

    # 查询最长周期: 1年时间
    if unit != '1d': return '您好,接口暂时不提供日级别以外的数据哟,我们会马不停蹄的加班,尽快把分钟、周和月级别的数据补全!'
    if market == 3 or market == 1: return '您好,接口暂时不提供美股/A股的数据哟,我们会马不停蹄的加班,尽快把美股的数据补全!'
    if start_date is None and end_date is None: return '您好,检测到end_date比start_date都是None,请修正后重新请求数据!'
    if start_date is not None and end_date is None:
        end_date = start_date
    if start_date is None and end_date is not None:
        start_date = end_date
    if start_date is not None and end_date is not None:
        if start_date > end_date: return '您好,检测到end_date比start_date要小哟,请修正后重新请求数据!'
        s_dt = datetime.datetime.strptime(start_date, '%Y-%m-%d')
        e_dt = datetime.datetime.strptime(end_date, '%Y-%m-%d')

        day_count = (e_dt - s_dt).days
        if day_count > 365 * 1: return '您好,技术指标接口一次最多只能提供1年的数据哟,如果需要更多的数据,请分段获取!'
    print('start_date:{}, end_date:{}'.format(start_date, end_date))

    body = {
        "codeList": code_list,
        "market": market,
        "queryType": queryType,
        "startDate": start_date,
        "endDate": end_date,
        "unit": unit,
        "ifRehabili": fre,
        "current": page,
        "size": 100
    }
    print('body:{}'.format(body))
    df_ = total_handle_req(body=body, URL=BE_TECH_POST_URL)
    print('--->df_:{}'.format(df_))
    return df_

###### 基础类技术面指标
def get_sar_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取SAR技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权  1 不复权/2 前复权/3 后复权
        Returns: 返回因子数据
    '''
    factor_names = ['SecuCode', 'Trend', 'WhetherTurn', 'AF', 'SAR1', 'SAR2', 'TradingDay']
    data_type = 'tradition'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_obv_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取OBV技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权  1 不复权/2 前复权/3 后复权
        Returns: 返回因子数据
        '''
    factor_names = ['SecuCode', 'OBV', 'TradingDay']
    data_type = 'tradition'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_boll_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取BOLL技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权  1 不复权/2 前复权/3 后复权
        Returns: 返回因子数据
        '''
    factor_names = ['SecuCode', 'MID', 'MD', 'UPPERValue', 'LOWERValue', 'TradingDay']
    data_type = 'tradition'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_wr_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取WR技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权  1 不复权/2 前复权/3 后复权
        Returns: 返回因子数据
        '''
    factor_names = ['SecuCode', 'WR6', 'WR10', 'WR13', 'WR34', 'WR89', 'TradingDay']
    data_type = 'tradition'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_rsi_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取RSI技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权  1 不复权/2 前复权/3 后复权
        Returns: 返回因子数据
        '''
    factor_names = ['SecuCode', 'RSI', 'RS', 'TradingDay']
    data_type = 'tradition'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_kdj_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取kdj技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权  1 不复权/2 前复权/3 后复权
        Returns: 返回因子数据
        '''
    factor_names = ['SecuCode', 'HighestInNine', 'LowestInNine', 'RSV', 'Kvalue', 'Dvalue', 'Jvalue', 'TradingDay']
    data_type = 'tradition'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_macd_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
    获取macd技术指标数据
    Args:
        code_list: 合约列表
        queryType:数据类型
        market: 市场类型：1 CH/ 2 HK/ 3 USA
        unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
        start_date: 开始日期
        end_date: 结束日期
        fre:是否复权  1 不复权/2 前复权/3 后复权
    Returns: 返回因子数据
    '''
    factor_names = ['SecuCode', 'EMA12', 'EMA26', 'DIF', 'DEA', 'MACD', 'TradingDay']
    data_type = 'tradition'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre):
    '''
    Args:
        factor_names:  所选因子字段
        f_data_: 后台api返回的数据
        data_type: 技术指标类型 tradition 传统技术指标；derived 衍生技术指标
        code_list: 合约列表
        start_date: 开始日期
        end_date: 结束日期
        market: 市场类型 1 CH/ 2 HK/ 3 USA
        unit: 频率 默认 '1d' 日级别数据
        fre: 是否复权  1 不复权/2 前复权/3 后复权
    Returns:
    '''

    pageSize = f_data_['totalPage']
    page1_data = f_data_['result']
    res_df = pd.DataFrame(page1_data)
    if pageSize > 1:
        res_df = _get_other_data(res_df, factor_names, pageSize, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = res_df[factor_names]
    __ = __.reset_index(drop=True)
    return __

def _get_other_data(page1_data, factor_names, page_size, data_type, code_list, start_date, end_date, market, unit, fre=2):
    # 获取剩下页码的数据
    df1_ = page1_data.copy()    #pd.DataFrame(page1_data)
    for pageC in range(2, page_size + 1):
        profit_data_next = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, pageC, fre)

        page_n_data = profit_data_next['result']
        df1_ = pd.concat([df1_, pd.DataFrame(page_n_data)], axis=0)
    return df1_

##### 衍生类技术面指标
def get_hbeta_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取Hbeta技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权 默认不复权
        Returns: 返回macd的因子数据
    '''
    factor_names = ['SecuCode', 'Hbeta', 'Trading_Day']
    data_type = 'derived'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_halpha_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取Halpha技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权 默认不复权
        Returns: 返回macd的因子数据
    '''
    factor_names = ['SecuCode', 'Halpha', 'Trading_Day']
    data_type = 'derived'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_hsigma_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取Hsigma技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权 默认不复权
        Returns: 返回macd的因子数据
    '''
    factor_names = ['SecuCode', 'Hsigma', 'Trading_Day']
    data_type = 'derived'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_hmsens_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取Dmsens技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权 默认不复权
        Returns: 返回macd的因子数据
    '''
    factor_names = ['SecuCode', 'Dmsens', 'Trading_Day']
    data_type = 'derived'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_oilsen_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取Oilsen技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权 默认不复权
        Returns: 返回macd的因子数据
    '''
    factor_names = ['SecuCode', 'Oilsen', 'Trading_Day']
    data_type = 'derived'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_dsbeta_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取Dsbeta技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权 默认不复权
        Returns: 返回macd的因子数据
    '''
    factor_names = ['SecuCode', 'Dsbeta', 'Trading_Day']
    data_type = 'derived'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_cmra_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取Cmra技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权 默认不复权
        Returns: 返回macd的因子数据
    '''
    factor_names = ['SecuCode', 'Cmra', 'Trading_Day']
    data_type = 'derived'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_stom_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取Stom技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权 默认不复权
        Returns: 返回macd的因子数据
    '''
    factor_names = ['SecuCode', 'Stom', 'Trading_Day']
    data_type = 'derived'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_stoq_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取Stoq技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权 默认不复权
        Returns: 返回macd的因子数据
    '''
    factor_names = ['SecuCode', 'Stoq', 'Trading_Day']
    data_type = 'derived'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_stoa_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取Stoa技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权 默认不复权
        Returns: 返回macd的因子数据
    '''
    factor_names = ['SecuCode', 'Stoa', 'Trading_Day']
    data_type = 'derived'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_dastd_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取Dastd技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权 默认不复权
        Returns: 返回macd的因子数据
    '''
    factor_names = ['SecuCode', 'Dastd', 'Trading_Day']
    data_type = 'derived'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_season_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取Season技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权 默认不复权
        Returns: 返回因子数据
    '''
    factor_names = ['SecuCode', 'Season', 'Trading_Day']
    data_type = 'derived'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_rstr_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取Rstr技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权 默认不复权
        Returns: 返回因子数据
    '''
    factor_names = ['SecuCode', 'Rstr', 'Trading_Day']
    data_type = 'derived'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    #
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def get_strev_factor_data(code_list=['00700'], market=2, unit='1d', start_date=None, end_date=None, fre=2):
    '''
        获取strev技术指标数据
        Args:
            code_list: 合约列表
            queryType:数据类型
            market: 市场类型：1 CH/ 2 HK/ 3 USA
            unit: 频率 默认为 '1d', 将支持如下周期: '5m', '15m', '30m', '1d', '1w', '1M'. '1w' 表示一周, '1M' 表示一月
            start_date: 开始日期
            end_date: 结束日期
            fre:是否复权 默认不复权
        Returns: 返回因子数据
    '''
    factor_names = ['SecuCode', 'Strev', 'Trading_Day']
    data_type = 'derived'
    # f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
    # if t_typeof(f_data_) == 'str':return f_data_
    # __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    __ = total_cls_handle(code_list, factor_names, data_type, start_date, end_date, market, unit, fre)
    return __

def total_cls_handle(code_list, factor_names, data_type=None, start_date=None, end_date=None, market=None, unit=None, fre=None):
    # 统一处理返回值
    try:
        code_list = list(set(code_list))
        f_data_ = _handle_ex_ret(code_list, data_type, start_date, end_date, market, unit, 1, fre)
        print('f_data_:{}'.format(f_data_))
        if t_typeof(f_data_) == 'str': return f_data_
        if [] == f_data_['result']:
            return '您好, 检测到时间区间的存在问题, 导致取到的数据为空, 请修改时间后重新请求数据.'

        __ = _get__(f_data_, factor_names, data_type, code_list, start_date, end_date, market, unit, fre)
    except:
        __ = '您好, 检测到入参存在问题, 导致取到的数据为空, 请修改后重新请求数据.'
    return __


if __name__ == '__main__':
    pass
