# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['py_linq_sql',
 'py_linq_sql.build_request',
 'py_linq_sql.config',
 'py_linq_sql.exception',
 'py_linq_sql.sql_enumerable',
 'py_linq_sql.utils',
 'py_linq_sql.utils.classes',
 'py_linq_sql.utils.functions']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0',
 'dotmap>=1.3.26,<2.0.0',
 'psycopg>=3.0.11,<4.0.0',
 'py-linq>=1.3.0,<2.0.0',
 'pytest-cov>=3.0.0,<4.0.0',
 'rich>=11.1.0,<12.0.0',
 'toml>=0.10.2,<0.11.0',
 'types-PyYAML>=6.0.9,<7.0.0',
 'types-toml>=0.10.7,<0.11.0']

setup_kwargs = {
    'name': 'py-linq-sql',
    'version': '1.0.0.1',
    'description': 'A Python module used for interacting with sql database using LINQ syntax.',
    'long_description': '<!-- markdownlint-disable-file MD024 MD041 -->\n\n![maintenance](https://img.shields.io/maintenance/yes/2022)\n![open issue](https://img.shields.io/gitlab/issues/open-raw/exoplanet/py-linq-sql?gitlab_url=https%3A%2F%2Fgitlab.obspm.fr)\n\n[![pipeline status](https://gitlab.obspm.fr/exoplanet/py-linq-sql/badges/main/pipeline.svg)](https://gitlab.obspm.fr/exoplanet/py-linq-sql/-/commits/main)\n[![coverage report](https://gitlab.obspm.fr/exoplanet/py-linq-sql/badges/main/coverage.svg)](https://gitlab.obspm.fr/exoplanet/py-linq-sql/-/commits/main)\n\n# Py-Linq-SQL\n\nA Python module used for interacting with sql database using [LINQ](https://docs.microsoft.com/fr-fr/dotnet/api/system.linq.enumerable?view=net-6.0)\nsyntax. The project is under [EUPL License v1.2](LICENSE.md).\n\nPy-linq-sql allows you to go from (SQLAlchemy using direct text query):\n\n```python\nconn.execute(\n  text(\n    """SELECT "data"->\'obj\'->\'name\' as name """\n    """FROM "objects" """\n    """WHERE "data"->\'obj\'->>\'name\' == "earth" """\n    """AND CAST("data"->\'obj\'->\'mass\' > 0.5 AS Decimal) """\n    """LIMIT 1 OFFSET 2"""\n  )\n)\n```\n\nto the safer and easier to read:\n\n```python\nsqle = (\n  SQLEnumerable(conn, "objects")  # objects is the name of the table\n  .select(lambda x: {"name": x.data.obj.name})  # data is a JSONB column\n  .where(lambda x: x.data.obj.mass > 0.5)  # data is a JSONB column\n  .skip(2)\n  .take(1)  # this is the last part of the query, till there nothing is executed\n  .execute()  # now we ask for the whole query to be executed on the DB server\n)\n```\n\nPro :\n\n- all the query expression are expressed in pure python expression\n- easy support of JSON database using a simple object notation\n- very difficult to have an SQL injection (only the names of the tables are strings)\n- standardized syntax/API of LINQ (used in java, C# and many .net languages)\n- very fast: even very long and complex queries are executed in one single query on the\n  server\n- no need to define a class for every table in the DB as you would do in an ORM here you\n  write query assuming the tables, columns and fields exist, if not then you get a clear\n  error about it\n- results are pylinq Enumerable that are themselves queryable in same way but locally\n- all kinds of join (inner, outer and full, with or without intersections) are easy to\n  use and combine with any kind of query\n\nCons :\n\n- currently only support PostgresQL\n\nAny feedback is welcome see [Contributing](CONTRIBUTING.md).\n\n## Contacts\n\n- Author: Ulysse CHOSSON (LESIA)\n- Maintainer: Ulysse CHOSSON (LESIA)\n- Email: <ulysse.chosson@obspm.fr>\n- Contributors:\n  - Pierre-Yves MARTIN (LESIA)\n\n## Table of Content\n\n- [Py-Linq-SQL](#py-linq-sql)\n  - [Contacts](#contacts)\n  - [Table of Content](#table-of-content)\n  - [Install](#install)\n  - [Implemented functions](#implemented-functions)\n    - [LINQ functions](#linq-functions)\n    - [Custom functions](#custom-functions)\n  - [Not implemented functions](#not-implemented-functions)\n    - [LINQ functions](#linq-functions-1)\n    - [Py-Linq functions](#py-linq-functions)\n  - [Contributing and info for developers](#contributing-and-info-for-developers)\n  - [Full documentation](#full-documentation)\n\n## Install\n\nFor all specific commands to this project, we use [just](https://github.com/casey/just).\n**You need to install it.**\n\nAfter you can install the dependencies:\n\n```bash\n$ just install\npwd\n/home/uchosson/Documents/py-linq-sql\npoetry install --no-dev --remove-untracked\nInstalling dependencies from lock file\nWarning: The lock file is not up to date with the latest changes in pyproject.toml.\nYou may be getting outdated dependencies. Run update to update them.\n\nNo dependencies to install or update\n\nInstalling the current project: py-linq-sql (0.109.0)\n```\n\nAnd if you need to develop the project, install development dependencies:\n\n```bash\n$ just install-all\npwd\n/home/uchosson/Documents/py-linq-sql\npoetry install --remove-untracked\nInstalling dependencies from lock file\nWarning: The lock file is not up to date with the latest changes in pyproject.toml.\nYou may be getting outdated dependencies. Run update to update them.\n\nNo dependencies to install or update\n\nInstalling the current project: py-linq-sql (0.109.0)\nnpm install\n\nup to date, audited 8 packages in 793ms\n\n1 package is looking for funding\n  run `npm fund` for details\n\nfound 0 vulnerabilities\nsudo npm install markdownlint-cli2 --global\n\nchanged 36 packages, and audited 37 packages in 2s\n\n8 packages are looking for funding\n  run `npm fund` for details\n\nfound 0 vulnerabilities\n```\n\nand the pre-commit dependencies:\n\n```bash\n$ just preinstall\npwd\n/home/uchosson/Documents/py-linq-sql\npre-commit clean\nCleaned /home/uchosson/.cache/pre-commit.\npre-commit autoupdate\nUpdating https://github.com/pre-commit/pre-commit-hooks ...\n[INFO] Initializing environment for https://github.com/pre-commit/pre-commit-hooks.\nalready up to date.\nUpdating https://github.com/pre-commit/pre-commit-hooks ... already up to date.\nUpdating https://github.com/pycqa/isort ...\n[INFO] Initializing environment for https://github.com/pycqa/isort.\nalready up to date.\nUpdating https://github.com/ambv/black ...\n[INFO] Initializing environment for https://github.com/ambv/black.\nalready up to date.\nUpdating https://github.com/codespell-project/codespell ...\n[INFO] Initializing environment for https://github.com/codespell-project/codespell.\nalready up to date.\nUpdating https://github.com/sqlfluff/sqlfluff ...\n[INFO] Initializing environment for https://github.com/sqlfluff/sqlfluff.\nupdating 1.1.0 -> 1.2.1.\nUpdating https://github.com/pycqa/flake8 ...\n[INFO] Initializing environment for https://github.com/pycqa/flake8.\nalready up to date.\nUpdating https://github.com/DavidAnson/markdownlint-cli2 ...\n[INFO] Initializing environment for https://github.com/DavidAnson/markdownlint-cli2.\nalready up to date.\npre-commit install --hook-type pre-merge-commit\npre-commit installed at .git/hooks/pre-merge-commit\npre-commit install --hook-type pre-push\npre-commit installed at .git/hooks/pre-push\npre-commit install --hook-type post-rewrite\npre-commit installed at .git/hooks/post-rewrite\npre-commit install-hooks\n[INFO] Installing environment for https://github.com/pre-commit/pre-commit-hooks.\n[INFO] Once installed this environment will be reused.\n[INFO] This may take a few minutes...\n[INFO] Installing environment for https://github.com/pycqa/isort.\n[INFO] Once installed this environment will be reused.\n[INFO] This may take a few minutes...\n[INFO] Installing environment for https://github.com/ambv/black.\n[INFO] Once installed this environment will be reused.\n[INFO] This may take a few minutes...\n[INFO] Installing environment for https://github.com/codespell-project/codespell.\n[INFO] Once installed this environment will be reused.\n[INFO] This may take a few minutes...\n[INFO] Installing environment for https://github.com/sqlfluff/sqlfluff.\n[INFO] Once installed this environment will be reused.\n[INFO] This may take a few minutes...\n[INFO] Installing environment for https://github.com/pycqa/flake8.\n[INFO] Once installed this environment will be reused.\n[INFO] This may take a few minutes...\n[INFO] Installing environment for https://github.com/DavidAnson/markdownlint-cli2.\n[INFO] Once installed this environment will be reused.\n[INFO] This may take a few minutes...\npre-commit install\npre-commit installed at .git/hooks/pre-commit\n```\n\n## Implemented functions\n\n### LINQ functions\n\n[LINQ documentation](https://docs.microsoft.com/fr-fr/dotnet/api/system.linq.enumerable?view=net-6.0)\n\nAll function make before an `.execute()` are executed by the database server.\n\nMDPA = MagicDotPathAggregate\n<!-- markdownlint-disable MD013 -->\n|Method Name           |Description                                                          |Output        |\n|:---------------------|:--------------------------------------------------------------------|:-------------|\n|all                   |Return True if all elements match the predicate.                     |SQLEnumerable |\n|any                   |Return True if any elements match the predicate.                     |SQLEnumerable |\n|avg                   |Aggregation function to get the average of the predicate.            |MDPA          |\n|contains              |Return True if at least one element match the predicate.             |SQLEnumerable |\n|concat                |Aggregation function to concat a predicate.                          |MDPA          |\n|count                 |Return the number of line in a table.                                |SQLEnumerable |\n|count                 |Aggregation function to count a predicate.                           |MDPA          |\n|distinct              |Return all elements that are not duplicate.                          |SQLEnumerable |\n|element_at            |Return the element at the specific index.                            |SQLEnumerable |\n|element_at_or_default |Return the element at the specific index or None if index > len.     |SQLEnumerable |\n|except                |Returns all elements except elements from another SQLEnumerable.     |SQLEnumerable |\n|first                 |Return the first element match the predicate.                        |SQLEnumerable |\n|first_or_default      |Return the first element match the predicate or None if none match.  |SQLEnumerable |\n|group_by              |Return the selection group by a predicate.                           |SQLEnumerable |\n|group_join            |Return the join between 2 selections group by a predicate.           |SQLEnumerable |\n|intersect             |Return the intersection between 2 selections.                        |SQLEnumerable |\n|join                  |Return the join between 2 selections.                                |SQLEnumerable |\n|last                  |Return the last element match the predicate.                         |SQLEnumerable |\n|last_or_default       |Return the last element match the predicate or None if none match.   |SQLEnumerable |\n|max                   |Return the max element.                                              |SQLEnumerable |\n|max                   |Aggregate function to get the max of predicate.                      |MDPA          |\n|min                   |Return the min element.                                              |SQLEnumerable |\n|min                   |Aggregate function to get the min of predicate.                      |MDPA          |\n|order_by              |Return the selection order by key(s).                                |SQLEnumerable |\n|order_by_descending   |Return the selection order by descending by key(s).                  |SQLEnumerable |\n|select                |Return a selection of elements.                                      |SQLEnumerable |\n|single                |Return the only element match the predicate.                         |SQLEnumerable |\n|single_or_default     |Return the only element match the predicate or None if many matches. |SQLEnumerable |\n|skip                  |Return the selection minus _X_ first elements.                       |SQLEnumerable |\n|skip_last             |Return the selection minus _X_ last elements.                        |SQLEnumerable |\n|sum                   |Aggregation function to get the sum of a predicate.                  |MDPA          |\n|take                  |Return _X_ first element of the selection.                           |SQLEnumerable |\n|take_last             |Return _X_ last element of the selection.                            |SQLEnumerable |\n|union                 |Return the union between 2 selections.                               |SQLEnumerable |\n|where                 |Return the selection with all elements match the predicate.          |SQLEnumerable |\n<!-- markdownlint-enable MD013 -->\n\nFor more information see the [detailed documentation](https://py-linq-sql.readthedocs.io/en/latest/api/sqle/sqlenumerable/).\n\n### Custom functions\n\n|Method Name |Description                              |Output                         |\n|:-----------|:----------------------------------------|:------------------------------|\n|delete      |Delete data in a SQL table.              |SQLEnumerable                  |\n|execute     |Execute a request from an SQLEnumerable. |Enumerable | int | bool | dict |\n|insert      |Insert data in a SQL table.              |SQLEnumerable                  |\n|update      |Update data in a table.                  |SQLEnumerable                  |\n\n## Not implemented functions\n\n### LINQ functions\n\n|Method Name      |Description     |\n|:----------------|:---------------|\n|append           |Not implemented |\n|default_if_empty |Not implemented |\n|empty            |Not implemented |\n|prepend          |Not implemented |\n|range            |Not implemented |\n|repeat           |Not implemented |\n|reverse          |Not implemented |\n|select_many      |Not implemented |\n|skip_while       |Not implemented |\n|take_while       |Not implemented |\n|to_dictionary    |Not implemented |\n|to_list          |Not implemented |\n|zip              |Not implemented |\n\n### Py-Linq functions\n\n|Method Name|Description     |\n|:----------|:---------------|\n|add        |Not implemented |\n|median     |Not implemented |\n\n[Py-Linq link](https://viralogic.github.io/py-enumerable)\n\n## Contributing and info for developers\n\n- [Changelog](CHANGELOG.md)\n- [Contributing](CONTRIBUTING.md)\n- [Our git workflow](https://py-linq-sql.readthedocs.io/en/latest/workflow/)\n\n## Full documentation\n\n- [Py-LINQ-SQL Documentation](https://py-linq-sql.readthedocs.io/en/latest/)\n',
    'author': 'CHOSSON Ulysse',
    'author_email': 'ulysse.chosson@obspm.fr',
    'maintainer': 'CHOSSON Ulysse',
    'maintainer_email': 'ulysse.chosson@obspm.fr',
    'url': 'https://gitlab.obspm.fr/exoplanet/py-linq-sql',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<3.11',
}


setup(**setup_kwargs)
