# -*- coding: utf-8 -*-
# Generated by Django 1.11.15 on 2018-10-03 17:07
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('NEMO', '0003_version_1_2_0'),
    ]

    operations = [
        migrations.CreateModel(
            name='News',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200)),
                ('created', models.DateTimeField(help_text='The date and time this story was first published')),
                ('original_content', models.TextField(help_text="The content of the story when it was first published, useful for visually hiding updates 'in the middle' of the story")),
                ('all_content', models.TextField(help_text='The entire content of the story')),
                ('last_updated', models.DateTimeField(help_text='The date and time this story was last updated')),
                ('last_update_content', models.TextField(help_text="The most recent update to the story, useful for visually hiding updates 'in the middle' of the story")),
                ('archived', models.BooleanField(default=False, help_text="A story is removed from the 'Recent News' page when it is archived")),
                ('update_count', models.PositiveIntegerField(help_text="The number of times this story has been updated. When the number of updates is greater than 2, then only the original story and the latest update are displayed in the 'Recent News' page")),
            ],
            options={
                'verbose_name_plural': 'News',
                'ordering': ['-last_updated'],
            },
        ),
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('expiration', models.DateTimeField()),
                ('object_id', models.PositiveIntegerField()),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notifications', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='landingpagechoice',
            name='notifications',
            field=models.CharField(blank=True, choices=[('news', 'News creation and updates - notifies all users'), ('safetyissue', 'New safety issues - notifies staff only')], help_text="Displays a the number of new notifications for the user. For example, if the user has two unread news notifications then the number '2' would appear for the news icon on the landing page.", max_length=25, null=True),
        ),
    ]
