from enum import Enum

class MemberType(Enum):
    '''
    Member Type
    '''
    TYPE_BEAM, TYPE_BUCKLING, TYPE_CABLE, TYPE_COMPRESSION, TYPE_COUPLING_HINGE_HINGE,\
    TYPE_COUPLING_HINGE_RIGID, TYPE_COUPLING_RIGID_HINGE, TYPE_COUPLING_RIGID_RIGID,\
    TYPE_DEFINABLE_STIFFNESS, TYPE_RIB, TYPE_RIGID, TYPE_TENSION, TYPE_TRUSS, TYPE_TRUSS_ONLY_N, TYPE_RESULT_BEAM = range(15)

class NodalSupportType(Enum):
    '''
    Nodal Support Type
    '''
    FIXED, HINGED, ROLLER, ROLLER_IN_X, ROLLER_IN_Y, ROLLER_IN_Z, FREE = range(7)

class LineSupportType(Enum):
    '''
    Nodal Support Type
    '''
    FIXED, HINGED, SLIDING_IN_X_AND_Y, SLIDING_IN_X, SLIDING_IN_Y, SLIDING_IN_Z, FREE = range(7)

class LineWeldedJointType(Enum):
    """
    Line Welded Joint Type | Enum
    """
    BUTT_JOINT, CORNER_JOINT, LAP_JOINT, TEE_JOINT = range(4)

class WeldType(Enum):
    """
    Welded Type | Enum
    """
    WELD_BEVEL_AND_FILLET, WELD_DOUBLE_BEVEL, WELD_DOUBLE_FILLET, WELD_DOUBLE_J,\
    WELD_DOUBLE_SQUARE, WELD_DOUBLE_U, WELD_DOUBLE_V, WELD_J_AND_FILLET, WELD_SINGLE_BEVEL,\
    WELD_SINGLE_FILLET, WELD_SINGLE_J, WELD_SINGLE_SQUARE, WELD_SINGLE_U, WELD_SINGLE_V, WELD_V_AND_FILLET = range(15)

class WeldLongitudalArrangement(Enum):
    """
    Weld Longitudat Arrangement Type | Enum
    """
    CHAIN_INTERMITTENT, CONTINUOUS, STAGGERED_INTERMITTENT = range(3)

class LineMeshRefinementsType(Enum):
    """
    Line Mesh Refinements Type | Enum
    """
    TYPE_LENGTH, TYPE_ELEMENTS, TYPE_GRADUAL = range(3)

class StaticAnalysisType(Enum):
    '''
    Static Analysis Type
    '''
    GEOMETRICALLY_LINEAR, LARGE_DEFORMATIONS, LARGE_DEFORMATIONS_POSTRCRITICAL, SECOND_ORDER_P_DELTA = range(4)

class StaticAnalysisSettingsIterativeMethodForNonlinearAnalysis(Enum):
    '''
    Static Analysis Settings Iterative Method For Nonlinear Analysis | Enum
    '''
    DYNAMIC_RELAXATION, NEWTON_RAPHSON, NEWTON_RAPHSON_COMBINED_WITH_PICARD, NEWTON_RAPHSON_WITH_CONSTANT_STIFFNESS,\
    NEWTON_RAPHSON_WITH_POSTCRITICAL_ANALYSIS, PICARD = range(6)


class StaticAnalysisSettingsMethodOfEquationSystem(Enum):
    '''
    Static Analysis Settings Method of Equation System | Enum
    '''
    METHOD_OF_EQUATION_SYSTEM_DIRECT, METHOD_OF_EQUATION_SYSTEM_ITERATIVE = range(2)


class StaticAnalysisSettingsPlateBendingTheory(Enum):
    '''
    Static Analysis Settings Plate Bending Theory | Enum
    '''
    PLATE_BENDING_THEORY_MINDLIN, PLATE_BENDING_THEORY_KIRCHHOFF = range(2)

class AnalysisType(Enum):
    '''
    Analysis Type
    '''
    ANALYSIS_TYPE_CREEP_AND_SHRINKAGE, ANALYSIS_TYPE_CUTTING_PATTERN, ANALYSIS_TYPE_MODAL, ANALYSIS_TYPE_RESPONSE_SPECTRUM,\
    ANALYSIS_TYPE_STATIC, ANALYSIS_TYPE_TIME_DEPENDENT, ANALYSIS_TYPE_TIME_HISTORY, ANALYSIS_TYPE_WIND_SIMULATION = range(8)

class LoadDirectionType(Enum):
    '''
    Load Direction Type
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W,\
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z = range(6)

class MemberLoadDirection(Enum):
    '''
    Member Load Direction
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_PROJECTED, LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE,\
    LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE,\
    LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE,\
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z, LOAD_DIRECTION_PRINCIPAL_U,\
    LOAD_DIRECTION_PRINCIPAL_V = range(11)

class MemberLoadType(Enum):
    '''
    Member Load Type
    '''
    E_TYPE_MASS, LOAD_TYPE_AXIAL_DISPLACEMENT, LOAD_TYPE_AXIAL_STRAIN, LOAD_TYPE_DISPLACEMENT, LOAD_TYPE_FORCE,\
    LOAD_TYPE_FORM_FINDING, LOAD_TYPE_INITIAL_PRESTRESS, LOAD_TYPE_MOMENT, LOAD_TYPE_PIPE_CONTENT_FULL,\
    LOAD_TYPE_PIPE_CONTENT_PARTIAL, LOAD_TYPE_PIPE_INTERNAL_PRESSURE, LOAD_TYPE_PRECAMBER, LOAD_TYPE_ROTARY_MOTION,\
    LOAD_TYPE_ROTATION, LOAD_TYPE_TEMPERATURE, LOAD_TYPE_TEMPERATURE_CHANGE = range(16)

class MemberLoadDistribution(Enum):
    '''
    Member Load Distribution
    '''
    LOAD_DISTRIBUTION_CONCENTRATED_1, LOAD_DISTRIBUTION_CONCENTRATED_2, LOAD_DISTRIBUTION_CONCENTRATED_2x2,\
    LOAD_DISTRIBUTION_CONCENTRATED_N, LOAD_DISTRIBUTION_CONCENTRATED_VARYING, LOAD_DISTRIBUTION_PARABOLIC,\
    LOAD_DISTRIBUTION_TAPERED, LOAD_DISTRIBUTION_TRAPEZOIDAL, LOAD_DISTRIBUTION_UNIFORM, LOAD_DISTRIBUTION_UNIFORM_TOTAL,\
    LOAD_DISTRIBUTION_VARYING, LOAD_DISTRIBUTION_VARYING_IN_Z = range(12)

class MemberHingeAxialRelease(Enum):
    '''
    Member Hinge Axial Release
    '''
    NONLINEARITY_TYPE_DIAGRAM, NONLINEARITY_TYPE_FAILURE_ALL_IF_NEGATIVE, NONLINEARITY_TYPE_FAILURE_ALL_IF_POSITIVE,\
    NONLINEARITY_TYPE_FAILURE_IF_NEGATIVE, NONLINEARITY_TYPE_FAILURE_IF_POSITIVE, NONLINEARITY_TYPE_FRICTION_DIRECTION_1,\
    NONLINEARITY_TYPE_FRICTION_DIRECTION_1_2, NONLINEARITY_TYPE_FRICTION_DIRECTION_1_PLUS_2, NONLINEARITY_TYPE_FRICTION_DIRECTION_2,\
    NONLINEARITY_TYPE_NONE, NONLINEARITY_TYPE_PARTIAL_ACTIVITY, NONLINEARITY_TYPE_STIFFNESS_DIAGRAM = range(12)

class LineLoadType(Enum):
    '''
    Line Load Type
    '''
    E_TYPE_MASS, LOAD_TYPE_FORCE, LOAD_TYPE_MOMENT = range(3)

class LineLoadDistribution(Enum):
    '''
    Line Load Distribution
    '''
    LOAD_DISTRIBUTION_CONCENTRATED_1, LOAD_DISTRIBUTION_CONCENTRATED_2, LOAD_DISTRIBUTION_CONCENTRATED_2x2,\
    LOAD_DISTRIBUTION_CONCENTRATED_N, LOAD_DISTRIBUTION_CONCENTRATED_VARYING, LOAD_DISTRIBUTION_PARABOLIC,\
    LOAD_DISTRIBUTION_TAPERED, LOAD_DISTRIBUTION_TRAPEZOIDAL, LOAD_DISTRIBUTION_UNIFORM, LOAD_DISTRIBUTION_UNIFORM_TOTAL,\
    LOAD_DISTRIBUTION_VARYING = range(11)

class SurfaceGeometry(Enum):
    '''
    Geometry Type
    '''
    GEOMETRY_PLANE, GEOMETRY_QUADRANGLE, GEOMETRY_NURBS, GEOMETRY_ROTATED, GEOMETRY_PIPE = range(5)

class SurfaceType(Enum):
    '''
    Stiffness Type
    '''
    TYPE_LOAD_TRANSFER, TYPE_MEMBRANE, TYPE_RIGID, TYPE_STANDARD, TYPE_WITHOUT_MEMBRANE_TENSION, TYPE_WITHOUT_THICKNESS = range(6)

class SurfaceLoadDistribution(Enum):
    '''
    Surface Load Distribution
    '''
    LOAD_DISTRIBUTION_LINEAR, LOAD_DISTRIBUTION_LINEAR_IN_X, LOAD_DISTRIBUTION_LINEAR_IN_Y, LOAD_DISTRIBUTION_LINEAR_IN_Z,\
    LOAD_DISTRIBUTION_RADIAL, LOAD_DISTRIBUTION_UNIFORM, LOAD_DISTRIBUTION_VARYING_IN_Z = range(7)

class SurfaceLoadDirection(Enum):
    '''
    Surface Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_PROJECTED, LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE,\
    LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE,\
    LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE,\
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z = range(9)

class SurfaceLoadType(Enum):
    '''
    Surface Load Type | Enum
    '''
    LOAD_TYPE_AXIAL_STRAIN, LOAD_TYPE_FORCE, LOAD_TYPE_FORM_FINDING, LOAD_TYPE_MASS, LOAD_TYPE_PRECAMBER,\
    LOAD_TYPE_ROTARY_MOTION, LOAD_TYPE_TEMPERATURE = range(7)

class SurfaceLoadDistributionDirection(Enum):
    '''
    Surface Load Distribution Direction
    '''
    LOAD_TRANSFER_DIRECTION_IN_BOTH, LOAD_TRANSFER_DIRECTION_IN_X, LOAD_TRANSFER_DIRECTION_IN_Y = range(3)
    #LOAD_DISTRIBUTION_DIRECTION_IN_BOTH, LOAD_DISTRIBUTION_DIRECTION_IN_X, LOAD_DISTRIBUTION_DIRECTION_IN_Y = range(3)

class SetType(Enum):
    '''
    Line, Member, Surface, and Solid Set Type
    '''
    SET_TYPE_CONTINUOUS, SET_TYPE_GROUP = range(2)

class NodalLoadType(Enum):
    '''
    Nodal Load Type
    '''
    LOAD_TYPE_COMPONENTS, LOAD_TYPE_FORCE, LOAD_TYPE_MASS, LOAD_TYPE_MOMENT = range(4)

class NodalLoadSpecificDirectionType(Enum):
    '''
    Nodal Load Specific Direction Type
    '''
    DIRECTION_TYPE_DIRECTED_TO_NODE, DIRECTION_TYPE_PARALLEL_TO_CS_OF_LINE, DIRECTION_TYPE_PARALLEL_TO_CS_OF_MEMBER, DIRECTION_TYPE_PARALLEL_TO_TWO_NODES, DIRECTION_TYPE_ROTATED_VIA_3_ANGLES = range(5)

class NodalLoadAxesSequence(Enum):
    '''
    Nodal Load Axes Sequence
    '''
    SEQUENCE_XYZ, SEQUENCE_XZY, SEQUENCE_YXZ, SEQUENCE_YZX, SEQUENCE_ZXY, SEQUENCE_ZYX = range(6)

class NodalLoadMassAxisRotation(Enum):
    '''
    Nodal Load Mass Axis Rotation
    '''

    AXIS_OF_ROTATION_X_NEGATIVE, AXIS_OF_ROTATION_X_POSITIVE, AXIS_OF_ROTATION_Y_NEGATIVE, AXIS_OF_ROTATION_Y_POSITIVE, AXIS_OF_ROTATION_Z_NEGATIVE, AXIS_OF_ROTATION_Z_POSITIVE = range(6)

class ThicknessType(Enum):
    '''
    Thickness Type
    '''
    TYPE_LAYERS, TYPE_SHAPE_ORTHOTROPY, TYPE_STIFFNESS_MATRIX, TYPE_THICKNESS_PHASE, TYPE_UNIFORM,\
    TYPE_VARIABLE_CIRCLE, TYPE_VARIABLE_FOUR_SURFACE_CORNERS, TYPE_VARIABLE_THREE_NODES, \
    TYPE_VARIABLE_TWO_NODES_AND_DIRECTION  = range(9)

class ThicknessDirection(Enum):
    '''
    Thickness Direction
    '''
    THICKNESS_DIRECTION_IN_SMALL_X, THICKNESS_DIRECTION_IN_SMALL_Y, THICKNESS_DIRECTION_IN_X, \
    THICKNESS_DIRECTION_IN_Y, THICKNESS_DIRECTION_IN_Z = range(5)

class ThicknessSelfWeightDefinitionType(Enum):
    SELF_WEIGHT_COMPUTED_FROM_PARAMETERS, SELF_WEIGHT_DEFINED_VIA_FICTITIOUS_THICKNESS, \
    SELF_WEIGHT_DEFINED_VIA_WEIGHT = range(3)

class ThicknessShapeOrthotropySelfWeightDefinitionType(Enum):
    '''
    Thickness Shape Orthotropy Self Weight Definition Type | Enum
    '''
    SELF_WEIGHT_COMPUTED_FROM_PARAMETERS, SELF_WEIGHT_DEFINED_VIA_FICTITIOUS_THICKNESS, \
    SELF_WEIGHT_DEFINED_VIA_WEIGHT = range(3)

class ThicknessStiffnessMatrixSelfWeightDefinitionType(Enum):
    '''
    Thickness Stiffness Matrix Self Weight Definition Type | Enum
    '''
    SELF_WEIGHT_DEFINITION_TYPE_DEFINED_VIA_BULK_DENSITY_AND_AREA_DENSITY, \
    SELF_WEIGHT_DEFINITION_TYPE_DEFINED_VIA_FICTITIOUS_THICKNESS_AND_AREA_DENSITY, \
    SELF_WEIGHT_DEFINITION_TYPE_DEFINED_VIA_FICTITIOUS_THICKNESS_AND_BULK_DENSITY = range(3)

class ThicknessOrthotropyType(Enum):
    BIDIRECTIONAL_RIBBED_PLATE, COUPLING, EFFECTIVE_THICKNESS, GRILLAGE, \
    HOLLOW_CORE_SLAB, TRAPEZOIDAL_SHEET, UNIDIRECTIONAL_RIBBED_PLATE = range(7)

class LineLoadDirection(Enum):
    '''
    Line Load Direction
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_PROJECTED, LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE,\
    LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE,\
    LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE,\
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z = range(9)


class MemberLoadEccentricityHorizontalAlignment(Enum):
    '''
    Member Load Eccentricity Horizontal Alignment
    '''

    ALIGN_LEFT, ALIGN_MIDDLE, ALIGN_NONE, ALIGN_TOP = range(4)

class MemberLoadEccentricityVerticalAlignment(Enum):
    '''
    Member Load Eccentricity Vertical Alignment
    '''

    ALIGN_LEFT, ALIGN_MIDDLE, ALIGN_NONE, ALIGN_TOP = range(4)

class MemberLoadEccentricitySectionMiddle(Enum):
    '''
    Member Load Eccentricity Section Middle
    '''

    LOAD_ECCENTRICITY_SECTION_MIDDLE_CENTER_OF_GRAVITY, LOAD_ECCENTRICITY_SECTION_MIDDLE_NONE, LOAD_ECCENTRICITY_SECTION_MIDDLE_SHEAR_CENTER = range(3)

class MemberLoadFormFindingDefinitionType(Enum):
    '''
    Member Load Form Finding Definition Type
    '''
    FORM_FINDING_TYPE_FORCE, FORM_FINDING_TYPE_GEOMETRIC = range(2)

class MemberLoadFormFindingForceDefinition(Enum):
    '''
    Member Load Form Finding Force Definition
    '''
    FORM_FINDING_FORCE_INPUT_PARAMETER_AVERAGE, FORM_FINDING_FORCE_INPUT_PARAMETER_DENSITY, FORM_FINDING_FORCE_INPUT_PARAMETER_HORIZONTAL_TENSION_COMPONENT, \
    FORM_FINDING_FORCE_INPUT_PARAMETER_MAXIMUM_FORCE_IN_MEMBER, FORM_FINDING_FORCE_INPUT_PARAMETER_MINIMAL_TENSION_AT_I_END, \
    FORM_FINDING_FORCE_INPUT_PARAMETER_MINIMAL_TENSION_AT_J_END, FORM_FINDING_FORCE_INPUT_PARAMETER_MINIMUM_FORCE_IN_MEMBER,\
    FORM_FINDING_FORCE_INPUT_PARAMETER_TENSION_AT_I_END, FORM_FINDING_FORCE_INPUT_PARAMETER_TENSION_AT_J_END = range(9)

class MemberLoadFormFindingGeometryDefinition(Enum):
    '''
    Member Load Form Finding Geometry Definition
    '''
    FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_LENGTH, FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_LOW_POINT_VERTICAL_SAG, \
    FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_MAXIMUM_VERTICAL_SAG, FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_SAG, \
    FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_UNSTRESSED_LENGTH = range(5)

class MemberLoadFormFindingInternalForce(Enum):
    '''
    Member Load Form Finding Internal Force
    '''
    FORM_FINDING_INTERNAL_FORCE_COMPRESSION, FORM_FINDING_INTERNAL_FORCE_TENSION = range(2)

class MemberLoadDirectionOrientation(Enum):
    '''
    Member Load Direction Orientation
    '''
    LOAD_DIRECTION_FORWARD, LOAD_DIRECTION_REVERSED = range(2)

class MemberLoadAxisDefinitionType(Enum):
    '''
    Member Load Axis Definition
    '''
    AXIS_DEFINITION_POINT_AND_AXIS, AXIS_DEFINITION_TWO_POINTS = range(2)

class MemberLoadAxisDefinition(Enum):
    '''
    Member Load Axis Definition
    '''
    AXIS_X, AXIS_Y, AXIS_Z = range(3)

class MemberLoadAxisDefinitionAxisOrientation(Enum):
    '''
    Member Load Axis Definition Axis Orientation
    '''
    AXIS_NEGATIVE, AXIS_POSITIVE = range(2)

class SurfaceLoadAxisDefinitionAxis(Enum):
    '''
    Surface Load Axis Definition Axis
    '''
    AXIS_X, AXIS_Y, AXIS_Z = range(3)

class SurfaceLoadAxisDirectionType(Enum):
    '''
    Surface Load Axis Direction Type
    '''
    AXIS_NEGATIVE, AXIS_POSITIVE = range(2)

class SurfaceLoadAxisDefinitionType(Enum):
    '''
    Surface Load Axis Definition Type
    '''
    AXIS_DEFINITION_POINT_AND_AXIS, AXIS_DEFINITION_TWO_POINTS = range(2)

class SurfaceLoadDirection(Enum):
    '''
    Surface Load Load Direction
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_PROJECTED, LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE,\
    LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE, LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z = range(9)

class SurfaceLoadType(Enum):
    '''
    Surface Load Type
    '''
    LOAD_TYPE_AXIAL_STRAIN, LOAD_TYPE_FORCE, LOAD_TYPE_FORM_FINDING, LOAD_TYPE_MASS, LOAD_TYPE_PRECAMBER, LOAD_TYPE_ROTARY_MOTION, LOAD_TYPE_TEMPERATURE = range(7)

class NodeType(Enum):
    '''
    Node Type | Enum
    '''
    TYPE_BETWEEN_TWO_NODES, TYPE_BETWEEN_TWO_POINTS, TYPE_ON_LINE, TYPE_ON_MEMBER, TYPE_STANDARD = range (5)

class NodeCoordinateSystemType(Enum):
    '''
    Node Coordinate System Type | Enum
    '''
    COORDINATE_SYSTEM_CARTESIAN, COORDINATE_SYSTEM_POLAR, COORDINATE_SYSTEM_X_CYLINDRICAL, COORDINATE_SYSTEM_Y_CYLINDRICAL, COORDINATE_SYSTEM_Z_CYLINDRICAL = range (5)

class NodeReferenceType(Enum):
    '''
    Node Reference Type| Enum
    '''
    REFERENCE_TYPE_L, REFERENCE_TYPE_XY, REFERENCE_TYPE_XZ, REFERENCE_TYPE_YZ = range (4)

class LineArcAlphaAdjustmentTarget(Enum):
    '''
    Line Arc Alpha Adjustment Target | Enum
    '''
    ALPHA_ADJUSTMENT_TARGET_ARC_CONTROL_POINT, ALPHA_ADJUSTMENT_TARGET_BEGINNING_OF_ARC, \
    ALPHA_ADJUSTMENT_TARGET_END_OF_ARC = range(3)
class MemberSetLoadType(Enum):
    '''
    Member Set Load Load Type
    '''
    E_TYPE_MASS, LOAD_TYPE_AXIAL_DISPLACEMENT, LOAD_TYPE_AXIAL_STRAIN, LOAD_TYPE_DISPLACEMENT, \
    LOAD_TYPE_FORCE, LOAD_TYPE_FORM_FINDING, LOAD_TYPE_INITIAL_PRESTRESS, LOAD_TYPE_MOMENT, \
    LOAD_TYPE_PIPE_CONTENT_FULL, LOAD_TYPE_PIPE_CONTENT_PARTIAL, LOAD_TYPE_PIPE_INTERNAL_PRESSURE, \
    LOAD_TYPE_PRECAMBER, LOAD_TYPE_ROTARY_MOTION, LOAD_TYPE_ROTATION, LOAD_TYPE_TEMPERATURE, LOAD_TYPE_TEMPERATURE_CHANGE  = range(16)

class MemberSetLoadDistribution(Enum):
    '''
    Member Set Load Distribution | Enum
    '''
    LOAD_DISTRIBUTION_CONCENTRATED_1, LOAD_DISTRIBUTION_CONCENTRATED_2, LOAD_DISTRIBUTION_CONCENTRATED_2x2,\
    LOAD_DISTRIBUTION_CONCENTRATED_N, LOAD_DISTRIBUTION_CONCENTRATED_VARYING, LOAD_DISTRIBUTION_PARABOLIC,\
    LOAD_DISTRIBUTION_TAPERED, LOAD_DISTRIBUTION_TRAPEZOIDAL, LOAD_DISTRIBUTION_UNIFORM, LOAD_DISTRIBUTION_UNIFORM_TOTAL,\
    LOAD_DISTRIBUTION_VARYING, LOAD_DISTRIBUTION_VARYING_IN_Z = range(12)

class MemberSetLoadDirection(Enum):
    '''
    Member Set Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_PROJECTED, LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE,\
    LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE,\
    LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE,\
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z, LOAD_DIRECTION_PRINCIPAL_U,\
    LOAD_DIRECTION_PRINCIPAL_V = range(11)

class MemberSetLoadDirectionOrientation(Enum):
    '''
    Member Set Load Direction Orientation
    '''
    LOAD_DIRECTION_FORWARD, LOAD_DIRECTION_REVERSED = range(2)

class MemberSetLoadFormFindingDefinitionType(Enum):
    '''
    Member Set Load Form Finding Definition Type
    '''
    FORM_FINDING_TYPE_FORCE, FORM_FINDING_TYPE_GEOMETRIC = range(2)

class MemberSetLoadAxisDefinitionType(Enum):
    '''
    Member Set Load Axis Definition
    '''
    AXIS_DEFINITION_POINT_AND_AXIS, AXIS_DEFINITION_TWO_POINTS = range(2)

class MemberSetLoadAxisDefinition(Enum):
    '''
    Member Set Load Axis Definition
    '''
    AXIS_X, AXIS_Y, AXIS_Z = range(3)

class MemberSetLoadAxisDefinitionAxisOrientation(Enum):
    '''
    Member Set Load Axis Definition Axis Orientation
    '''
    AXIS_NEGATIVE, AXIS_POSITIVE = range(2)

class MemberSetLoadEccentricityHorizontalAlignment(Enum):
    '''
    Member Set Load Eccentricity Horizontal Alignment
    '''
    ALIGN_LEFT, ALIGN_MIDDLE, ALIGN_NONE, ALIGN_RIGHT = range(4)

class MemberSetLoadEccentricityVerticalAlignment(Enum):
    '''
    Member Set Load Eccentricity Vertical Alignment
    '''
    ALIGN_LEFT, ALIGN_MIDDLE, ALIGN_NONE, ALIGN_TOP = range(4)

class MemberSetLoadEccentricitySectionMiddle(Enum):
    '''
    Member Set Load Eccentricity Section Middle
    '''
    LOAD_ECCENTRICITY_SECTION_MIDDLE_CENTER_OF_GRAVITY, LOAD_ECCENTRICITY_SECTION_MIDDLE_NONE, LOAD_ECCENTRICITY_SECTION_MIDDLE_SHEAR_CENTER = range(3)

class MemberSetLoadFormFindingInternalForce(Enum):
    '''
    Member Set Load Form Finding Internal Force
    '''
    FORM_FINDING_INTERNAL_FORCE_COMPRESSION, FORM_FINDING_INTERNAL_FORCE_TENSION = range(2)

class MemberSetLoadFormFindingGeometryDefinition(Enum):
    '''
    Member Set Load Form Finding Geometry Definition
    '''
    FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_LENGTH, FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_LOW_POINT_VERTICAL_SAG, FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_MAXIMUM_VERTICAL_SAG, \
    FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_SAG, FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_UNSTRESSED_LENGTH = range(5)

class MemberSetLoadFormFindingForceDefinition(Enum):
    '''
    Member Set Load Form Finding Force Definition
    '''
    FORM_FINDING_FORCE_INPUT_PARAMETER_AVERAGE, FORM_FINDING_FORCE_INPUT_PARAMETER_DENSITY, FORM_FINDING_FORCE_INPUT_PARAMETER_HORIZONTAL_TENSION_COMPONENT, \
    FORM_FINDING_FORCE_INPUT_PARAMETER_MAXIMUM_FORCE_IN_MEMBER, FORM_FINDING_FORCE_INPUT_PARAMETER_MINIMAL_TENSION_AT_I_END, FORM_FINDING_FORCE_INPUT_PARAMETER_MINIMAL_TENSION_AT_J_END, \
    FORM_FINDING_FORCE_INPUT_PARAMETER_MINIMUM_FORCE_IN_MEMBER, FORM_FINDING_FORCE_INPUT_PARAMETER_TENSION_AT_I_END, FORM_FINDING_FORCE_INPUT_PARAMETER_TENSION_AT_J_END = range(9)

class SurfaceSetLoadType(Enum):
    '''
    Surface Set Load Load Type
    '''
    LOAD_TYPE_AXIAL_STRAIN, LOAD_TYPE_FORCE, LOAD_TYPE_FORM_FINDING, LOAD_TYPE_MASS, LOAD_TYPE_PRECAMBER,\
    LOAD_TYPE_ROTARY_MOTION, LOAD_TYPE_TEMPERATURE = range(7)

class SurfaceSetLoadDistribution(Enum):
    '''
    Surface Set Load Load Distribution
    '''
    LOAD_DISTRIBUTION_LINEAR, LOAD_DISTRIBUTION_LINEAR_IN_X, LOAD_DISTRIBUTION_LINEAR_IN_Y, LOAD_DISTRIBUTION_LINEAR_IN_Z,\
    LOAD_DISTRIBUTION_RADIAL, LOAD_DISTRIBUTION_UNIFORM, LOAD_DISTRIBUTION_VARYING_IN_Z = range(7)

class SurfaceSetLoadDirection(Enum):
    '''
    Surface Set Load Direction
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_PROJECTED, LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE,\
    LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE,\
    LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE,\
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z = range(9)

class SurfaceSetLoadAxisDefinitionType(Enum):
    '''
    Surface Set Load Axis Definiton Type
    '''
    AXIS_DEFINITION_POINT_AND_AXIS, AXIS_DEFINITION_TWO_POINTS = range(2)

class SurfaceSetLoadAxisDefinitionAxis(Enum):
    '''
    Surface Set Load Axis Definition Axis
    '''
    AXIS_X, AXIS_Y, AXIS_Z = range(3)

class SurfaceSetLoadAxisDefinitionAxisOrientation(Enum):
    '''
    Surface Set Load Axis Definition Axis Orientation
    '''
    AXIS_NEGATIVE, AXIS_POSITIVE = range(2)

class SurfaceSetLoadFormFindingDefinition(Enum):
    '''
    Surface Set Load Form Finding Definition
    '''
    FORM_FINDING_DEFINITION_FORCE, FORM_FINDING_DEFINITION_STRESS = range(2)

class SurfaceSetLoadFormFindingCalculationMethod(Enum):
    '''
    Surface Set Load Form Finding Calculation Method
    '''
    FORM_FINDING_CALCULATION_METHOD_PROJECTION, FORM_FINDING_CALCULATION_METHOD_STANDARD = range(2)

class GlobalParameterUnitGroup(Enum):
    '''
    Global Parameter Unit Group | Enum
    '''
    ANGLE, AREA, DENSITY, DIMENSIONLESS, DYNAMIC_INCREASE_FACTOR, EG_MODULE, FRICTION_COEFFICIENT, \
    GEOGRAPHIC_COORDINATES, GRAVITATIONAL_ACCELERATION, LENGTH, LOADS_ANGULAR_ACCELERATION, LOADS_ANGULAR_VELOCITY, \
    LOADS_AREA_MASS, LOADS_AXIAL_STRAIN, LOADS_DENSITY, LOADS_DISPLACEMENT, LOADS_DISPLACEMENT_PER_UNIT_LENGTH, \
    LOADS_FORCE, LOADS_FORCE_PER_UNIT_LENGTH, LOADS_IMPOSED_DISPLACEMENT, LOADS_IMPOSED_ROTATION, LOADS_KINEMATIC_VISCOSITY, \
    LOADS_KINETIC_ENERGY, LOADS_LENGTH, LOADS_MASS, LOADS_MOMENT, LOADS_MOMENT_PER_UNIT_LENGTH, LOADS_PRECAMBER, \
    LOADS_PRESSURE, LOADS_RELATIVE_LENGTH, LOADS_ROTATION, LOADS_ROTATION_PER_UNIT_LENGTH, LOADS_SOLID_TYPE_LOAD, \
    LOADS_SPECIFIC_ENERGY, LOADS_SURFACE_TYPE_LOAD, LOADS_TEMPERATURE, LOADS_TEMPERATURE_CHANGE, LOADS_VELOCITY, \
    MASS, MASS_MOMENT_PER_UNIT_AREA, MATERIAL_ANGLE, MATERIAL_DEFORMATION, MATERIAL_FACTOR, MATERIAL_QUANTITY_INTEGER, \
    MATERIAL_SPECIFIC_WEIGHT, MATERIAL_THICKNESS, PARTIAL_FACTOR, POISSONS_RATIO, PRECISION_FACTOR, QUANTITY, QUANTITY_INTEGER ,\
    RATIO, RELATIVE_LENGTH, SECTION_ANGLE, SECTION_AREA, SECTION_BIMOMENT, SECTION_COMPLIANCE, SECTION_DIMENSION, \
    SECTION_EFFECTIVE_SECOND_MOMENT_OF_AREA, SECTION_FORCE, SECTION_MOMENT, SECTION_MOMENT_OF_INERTIA, \
    SECTION_NORMALIZED_WARPING_CONSTANT, SECTION_PERIMETER, SECTION_QUANTITY, SECTION_SECTION_FACTOR, SECTION_SECTION_MODULUS, \
    SECTION_STATICAL_MOMENT_OF_AREA, SECTION_TENSION_FIELD_COEFFICIENT_1, SECTION_TENSION_FIELD_COEFFICIENT_2, \
    SECTION_UNIT_STRESSES, SECTION_UNIT_WARPING_FUNCTION, SECTION_WARPING_CONSTANT, SECTION_WARPING_STATICAL_MOMENT, \
    SELF_WEIGHT_FACTOR, STIFFNESS_MULTIPLICATION_FACTOR, STRAIN, STRAIN_RATE, STRESSES, THERMAL_EXPANSION_COEFFICIENT, \
    THICKNESS, TIME, VOLUME, WEIGHT_AND_KNOT = range(84)

class GlobalParameterDefinitionType(Enum):
    '''
    Global Parameter Definition Type
    '''
    DEFINITION_TYPE_FORMULA, DEFINITION_TYPE_OPTIMIZATION, DEFINITION_TYPE_OPTIMIZATION_ASCENDING, \
    DEFINITION_TYPE_OPTIMIZATION_DESCENDING, DEFINITION_TYPE_VALUE = range(5)

class FreeConcentratedLoadLoadDirection(Enum):
    '''
    Load Concentrated Load Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X, LOAD_DIRECTION_GLOBAL_Y, LOAD_DIRECTION_GLOBAL_Z, LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, \
    LOAD_DIRECTION_LOCAL_Z, LOAD_DIRECTION_USER_DEFINED_U, LOAD_DIRECTION_USER_DEFINED_V, LOAD_DIRECTION_USER_DEFINED_W = range(9)

class FreeLoadLoadProjection(Enum):
    '''
    Free Load Load Projection | Enum
    '''
    LOAD_PROJECTION_XY_OR_UV, LOAD_PROJECTION_XZ_OR_UW, LOAD_PROJECTION_YZ_OR_VW = range(3)

class FreeConcentratedLoadLoadType(Enum):
    '''
    Free Concentrated Load Load Type | Enum
    '''
    LOAD_TYPE_FORCE, LOAD_TYPE_MOMENT = range(2)

class FreeLineLoadLoadDirection(Enum):
    '''
    Free Line Load Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_PROJECTED, LOAD_DIRECTION_GLOBAL_X_TRUE, LOAD_DIRECTION_GLOBAL_Y_PROJECTED, \
    LOAD_DIRECTION_GLOBAL_Y_TRUE, LOAD_DIRECTION_GLOBAL_Z_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_TRUE, \
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z, LOAD_DIRECTION_USER_DEFINED_U_PROJECTED, \
    LOAD_DIRECTION_USER_DEFINED_U_TRUE, LOAD_DIRECTION_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_USER_DEFINED_V_TRUE, \
    LOAD_DIRECTION_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_USER_DEFINED_W_TRUE = range(15)

class FreeLineLoadLoadDistribution(Enum):
    '''
    Free Line Load Load Distribution | Enum
    '''
    LOAD_DISTRIBUTION_LINEAR, LOAD_DISTRIBUTION_UNIFORM = range(2)

class FreeRectangularLoadLoadDirection(Enum):
    '''
    Free Rectangular Load Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_PROJECTED, LOAD_DIRECTION_GLOBAL_X_TRUE, LOAD_DIRECTION_GLOBAL_Y_PROJECTED, \
    LOAD_DIRECTION_GLOBAL_Y_TRUE, LOAD_DIRECTION_GLOBAL_Z_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_TRUE, \
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z, LOAD_DIRECTION_USER_DEFINED_U_PROJECTED, \
    LOAD_DIRECTION_USER_DEFINED_U_TRUE, LOAD_DIRECTION_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_USER_DEFINED_V_TRUE, \
    LOAD_DIRECTION_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_USER_DEFINED_W_TRUE = range(15)

class FreeRectangularLoadLoadDistribution(Enum):
    '''
    Free Rectangular Load Load Distribution | Enum
    '''
    LOAD_DISTRIBUTION_LINEAR_FIRST, LOAD_DISTRIBUTION_LINEAR_SECOND, LOAD_DISTRIBUTION_UNIFORM, \
    LOAD_DISTRIBUTION_VARYING_ALONG_PERIMETER, LOAD_DISTRIBUTION_VARYING_IN_Z, \
    LOAD_DISTRIBUTION_VARYING_IN_Z_AND_ALONG_PERIMETER = range(6)

class FreeRectangularLoadLoadLocationRectangle(Enum):
    '''
    Free Rectangular Load Load Location Rectangle | Enum
    '''
    LOAD_LOCATION_RECTANGLE_CENTER_AND_SIDES, LOAD_LOCATION_RECTANGLE_CORNER_POINTS = range(2)

class FreeCircularLoadLoadDirection(Enum):
    '''
    Free Circular Load Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_PROJECTED, LOAD_DIRECTION_GLOBAL_X_TRUE, LOAD_DIRECTION_GLOBAL_Y_PROJECTED, \
    LOAD_DIRECTION_GLOBAL_Y_TRUE, LOAD_DIRECTION_GLOBAL_Z_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_TRUE, \
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z, LOAD_DIRECTION_USER_DEFINED_U_PROJECTED, \
    LOAD_DIRECTION_USER_DEFINED_U_TRUE, LOAD_DIRECTION_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_USER_DEFINED_V_TRUE, \
    LOAD_DIRECTION_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_USER_DEFINED_W_TRUE = range(15)

class FreeCircularLoadLoadDistribution(Enum):
    '''
    Free Circular Load Load Distribution | Enum
    '''
    LOAD_DISTRIBUTION_LINEAR, LOAD_DISTRIBUTION_UNIFORM = range(2)

class FreePolygonLoadLoadDirection(Enum):
    '''
    Free Polygon Load Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_PROJECTED, LOAD_DIRECTION_GLOBAL_X_TRUE, LOAD_DIRECTION_GLOBAL_Y_PROJECTED, \
    LOAD_DIRECTION_GLOBAL_Y_TRUE, LOAD_DIRECTION_GLOBAL_Z_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_TRUE, \
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z, LOAD_DIRECTION_USER_DEFINED_U_PROJECTED, \
    LOAD_DIRECTION_USER_DEFINED_U_TRUE, LOAD_DIRECTION_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_USER_DEFINED_V_TRUE, \
    LOAD_DIRECTION_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_USER_DEFINED_W_TRUE = range(15)

class FreePolygonLoadLoadDistribution(Enum):
    '''
    Free Polygon Load Load Distribution | Enum
    '''
    LOAD_DISTRIBUTION_LINEAR, LOAD_DISTRIBUTION_LINEAR_FIRST, LOAD_DISTRIBUTION_LINEAR_SECOND, LOAD_DISTRIBUTION_UNIFORM = range(4)

class RigidLinkType(Enum):
    '''
    Rigid Link Type | Enum
    '''
    TYPE_LINE_TO_LINE, TYPE_LINE_TO_SURFACE, TYPE_DIAPHRAGM = range(3)

class SolidType(Enum):
    '''
    Solid Type | Enum
    '''
    TYPE_STANDARD, TYPE_GAS, TYPE_CONTACT, TYPE_HOLE, TYPE_SOIL = range(5)

class SolidLoadType(Enum):
    '''
    Solid Load Load Type | Enum
    '''
    LOAD_TYPE_BUOYANCY, LOAD_TYPE_FORCE, LOAD_TYPE_GAS, LOAD_TYPE_ROTARY_MOTION, LOAD_TYPE_STRAIN, LOAD_TYPE_TEMPERATURE = range(6)

class SolidLoadDistribution(Enum):
    '''
    Solid Load Load Distribution | Enum
    '''
    LOAD_DISTRIBUTION_LINEAR_IN_X, LOAD_DISTRIBUTION_LINEAR_IN_Y, LOAD_DISTRIBUTION_LINEAR_IN_Z, LOAD_DISTRIBUTION_UNIFORM = range(4)

class SolidLoadDirection(Enum):
    '''
    Solid Load Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE = range(3)
class SolidSetLoadType(Enum):
    '''
    Solidset Load Load Type | Enum
    '''
    LOAD_TYPE_BUOYANCY, LOAD_TYPE_FORCE, LOAD_TYPE_GAS, LOAD_TYPE_ROTARY_MOTION, LOAD_TYPE_STRAIN, LOAD_TYPE_TEMPERATURE = range(6)

class SolidSetLoadDistribution(Enum):
    '''
    Solidset Load Load Distribution | Enum
    '''
    LOAD_DISTRIBUTION_LINEAR_IN_X, LOAD_DISTRIBUTION_LINEAR_IN_Y, LOAD_DISTRIBUTION_LINEAR_IN_Z, LOAD_DISTRIBUTION_UNIFORM = range(4)

class SolidSetLoadDirection(Enum):
    '''
    Solidset Load Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE = range(3)


class StabilityAnalysisSettingsAnalysisType(Enum):
    '''
    Stability Analysis Settings Analysis Type | Enum
    '''
    EIGENVALUE_METHOD, INCREMENTALY_METHOD_WITHOUT_EIGENVALUE, \
    INCREMENTALY_METHOD_WITH_EIGENVALUE = range(3)

class StabilityAnalysisSettingsEigenvalueMethod(Enum):
    '''
    Stability Analysis Settings Eigenvalue Method | Enum
    '''
    EIGENVALUE_METHOD_ICG_ITERATION, EIGENVALUE_METHOD_LANCZOS, \
    EIGENVALUE_METHOD_ROOTS_OF_CHARACTERISTIC_POLYNOMIAL, \
    EIGENVALUE_METHOD_SUBSPACE_ITERATION, E_EIGENVALUE_METHOD_SHIFTED_INVERSE_POWER_METHOD = range(5)

class StabilityAnalysisSettingsMatrixType(Enum):
    '''
    Stability Analysis Settings Matrix Type | Enum
    '''
    MATRIX_TYPE_STANDARD, MATRIX_TYPE_UNIT = range(2)

class StabilityAnalysisSettingsStoppingOfLoadIncreasingResult(Enum):
    '''
    Stability Analysis Settings Stopping Of Load Increasing Result | Enum
    '''
    RESULT_TYPE_DISPLACEMENT_U, RESULT_TYPE_DISPLACEMENT_U_X, RESULT_TYPE_DISPLACEMENT_U_Y, \
    RESULT_TYPE_DISPLACEMENT_U_Z, RESULT_TYPE_ROTATION_PHI, RESULT_TYPE_ROTATION_PHI_X, \
    RESULT_TYPE_ROTATION_PHI_Y, RESULT_TYPE_ROTATION_PHI_Z = range(8)
class LineType(Enum):
    '''
    Line Type
    '''
    TYPE_ARC, TYPE_CIRCLE, TYPE_CUT_VIA_SECTION, TYPE_CUT_VIA_TWO_LINES, TYPE_ELLIPTICAL_ARC, TYPE_ELLIPSE, TYPE_NURBS, TYPE_PARABOLA, TYPE_POLYLINE, TYPE_SPLINE = range(10)

class ObjectTypes(Enum):
    '''
    Object Types
    '''
    E_OBJECT_TYPE_ACTION, E_OBJECT_TYPE_ACTION_COMBINATION, E_OBJECT_TYPE_BUILDING_STORY, E_OBJECT_TYPE_CLIPPING_BOX, E_OBJECT_TYPE_CLIPPING_PLANE, E_OBJECT_TYPE_COMBINATION_WIZARD, E_OBJECT_TYPE_COORDINATE_SYSTEM,\
    E_OBJECT_TYPE_CUTTING_LINE_SETTING, E_OBJECT_TYPE_CUTTING_PATTERN, E_OBJECT_TYPE_DESIGN_SITUATION, E_OBJECT_TYPE_DESIGN_SUPPORT, E_OBJECT_TYPE_DIMENSION, E_OBJECT_TYPE_FREE_CIRCULAR_LOAD, E_OBJECT_TYPE_FREE_CONCENTRATED_LOAD,\
    E_OBJECT_TYPE_FREE_LINE_LOAD, E_OBJECT_TYPE_FREE_POLYGON_LOAD, E_OBJECT_TYPE_FREE_RECTANGULAR_LOAD, E_OBJECT_TYPE_IMPERFECTION_CASE, E_OBJECT_TYPE_IMPOSED_LINE_DEFORMATION, E_OBJECT_TYPE_IMPOSED_NODAL_DEFORMATION,\
    E_OBJECT_TYPE_INTERSECTION, E_OBJECT_TYPE_LINE, E_OBJECT_TYPE_LINE_GRID, E_OBJECT_TYPE_LINE_HINGE, E_OBJECT_TYPE_LINE_LOAD, E_OBJECT_TYPE_LINE_MESH_REFINEMENT, E_OBJECT_TYPE_LINE_SET, E_OBJECT_TYPE_LINE_SET_LOAD,\
    E_OBJECT_TYPE_LINE_SUPPORT, E_OBJECT_TYPE_LINE_WELDED_JOINT, E_OBJECT_TYPE_LOAD_CASE, E_OBJECT_TYPE_LOAD_COMBINATION, E_OBJECT_TYPE_MATERIAL, E_OBJECT_TYPE_MEMBER, E_OBJECT_TYPE_MEMBER_DEFINABLE_STIFFNESS,\
    E_OBJECT_TYPE_MEMBER_ECCENTRICITY, E_OBJECT_TYPE_MEMBER_HINGE, E_OBJECT_TYPE_MEMBER_IMPERFECTION, E_OBJECT_TYPE_MEMBER_LOAD, E_OBJECT_TYPE_MEMBER_NONLINEARITY, E_OBJECT_TYPE_MEMBER_REPRESENTATIVE,\
    E_OBJECT_TYPE_MEMBER_RESULT_INTERMEDIATE_POINT, E_OBJECT_TYPE_MEMBER_SET, E_OBJECT_TYPE_MEMBER_SET_IMPERFECTION, E_OBJECT_TYPE_MEMBER_SET_LOAD, E_OBJECT_TYPE_MEMBER_SET_REPRESENTATIVE, E_OBJECT_TYPE_MEMBER_STIFFNESS_MODIFICATION,\
    E_OBJECT_TYPE_MEMBER_SUPPORT, E_OBJECT_TYPE_MEMBER_TRANSVERSE_STIFFENER, E_OBJECT_TYPE_NODAL_LOAD, E_OBJECT_TYPE_NODAL_MESH_REFINEMENT, E_OBJECT_TYPE_NODAL_SUPPORT, E_OBJECT_TYPE_NODE, E_OBJECT_TYPE_NOTE, E_OBJECT_TYPE_OBJECT_SNAP,\
    E_OBJECT_TYPE_OPENING, E_OBJECT_TYPE_OPENING_LOAD, E_OBJECT_TYPE_RESULT_COMBINATION, E_OBJECT_TYPE_RESULT_SECTION, E_OBJECT_TYPE_RIGID_LINK, E_OBJECT_TYPE_SECTION, E_OBJECT_TYPE_SOIL_SAMPLE, E_OBJECT_TYPE_SOLID,\
    E_OBJECT_TYPE_SOLID_CONTACTS, E_OBJECT_TYPE_SOLID_GAS, E_OBJECT_TYPE_SOLID_LOAD, E_OBJECT_TYPE_SOLID_MESH_REFINEMENT, E_OBJECT_TYPE_SOLID_SET, E_OBJECT_TYPE_SOLID_SET_LOAD, E_OBJECT_TYPE_STATIC_ANALYSIS_SETTINGS,\
    E_OBJECT_TYPE_STRUCTURE_MODIFICATION, E_OBJECT_TYPE_SURFACE, E_OBJECT_TYPE_SURFACES_CONTACT, E_OBJECT_TYPE_SURFACES_CONTACT_TYPE, E_OBJECT_TYPE_SURFACE_ECCENTRICITY, E_OBJECT_TYPE_SURFACE_IMPERFECTION,\
    E_OBJECT_TYPE_SURFACE_LOAD, E_OBJECT_TYPE_SURFACE_MESH_REFINEMENT, E_OBJECT_TYPE_SURFACE_RESULTS_ADJUSTMENT, E_OBJECT_TYPE_SURFACE_SET, E_OBJECT_TYPE_SURFACE_SET_IMPERFECTION, E_OBJECT_TYPE_SURFACE_SET_LOAD,\
    E_OBJECT_TYPE_SURFACE_STIFFNESS_MODIFICATION, E_OBJECT_TYPE_SURFACE_SUPPORT, E_OBJECT_TYPE_THICKNESS, E_OBJECT_TYPE_VISUAL_OBJECT = range(86)

class export_to_ifc_axis_rotation_sequence_type(Enum):
    '''
    Export to IFC Axis Rotation Sequence Type
    '''
    XYZ, XZY, YXZ, YZX, ZXY, ZYX = range(6)

class export_to_ifc_axis_type(Enum):
    '''
    Export to IFC Axis Type
    '''
    X,Y,Z = range(3)

class export_to_ifc_export_type(Enum):
    '''
    Export to IFC Export Type
    '''
    E_EXPORT_IFC4_REFERENCE_VIEW, E_EXPORT_IFC4_STRUCTURAL_ANALYSIS_VIEW = range(2)

class MemberSectionDistributionType(Enum):
    '''
    Member Section Distribution Type
    '''
    SECTION_DISTRIBUTION_TYPE_LINEAR, SECTION_DISTRIBUTION_TYPE_OFFSET_AT_BOTH_SIDES, SECTION_DISTRIBUTION_TYPE_OFFSET_AT_END_OF_MEMBER, \
    SECTION_DISTRIBUTION_TYPE_OFFSET_AT_START_OF_MEMBER, SECTION_DISTRIBUTION_TYPE_SADDLE, SECTION_DISTRIBUTION_TYPE_TAPERED_AT_BOTH_SIDES, \
    SECTION_DISTRIBUTION_TYPE_TAPERED_AT_END_OF_MEMBER, SECTION_DISTRIBUTION_TYPE_TAPERED_AT_START_OF_MEMBER, SECTION_DISTRIBUTION_TYPE_UNIFORM = range(9)

class MemberReferenceType(Enum):
    '''
    Member Reference Type
    '''
    REFERENCE_TYPE_L, REFERENCE_TYPE_XY, REFERENCE_TYPE_XZ, REFERENCE_TYPE_YZ = range(4)

class MemberTypeRibAlignment(Enum):
    '''
    Member Type Rib Alignment
    '''
    ALIGNMENT_CENTRIC, ALIGNMENT_ON_Z_SIDE_NEGATIVE, ALIGNMENT_ON_Z_SIDE_POSITIVE, ALIGNMENT_USER_DEFINED_VIA_MEMBER_ECCENTRICITY = range(4)

class MemberReferenceLengthType(Enum):
    '''
    Member Reference Length Definition Type
    '''
    REFERENCE_LENGTH_TYPE_MEMBER_LENGTH, REFERENCE_LENGTH_TYPE_SEGMENT_LENGTH, REFERENCE_LENGTH_TYPE_USER_DEFINED = range(3)

class MemberReferenceLengthWidthType(Enum):
    '''
    Member Reference Length Width Type
    '''
    REFERENCE_LENGTH_WIDTH_EC2, REFERENCE_LENGTH_WIDTH_EIGHTH, REFERENCE_LENGTH_WIDTH_NONE, REFERENCE_LENGTH_WIDTH_SIXTH = range(4)

class MemberResultBeamIntegration(Enum):
    '''
    Member Result Beam Integrate Stresses and Forces
    '''
    INTEGRATE_FROM_LISTED_OBJECT, INTEGRATE_WITHIN_CUBOID_GENERAL, INTEGRATE_WITHIN_CUBOID_QUADRATIC, INTEGRATE_WITHIN_CYLINDER = range(4)

class MemberSectionAlignment(Enum):
    '''
    Member Section Alignment
    '''
    SECTION_ALIGNMENT_BOTTOM, SECTION_ALIGNMENT_CENTRIC, SECTION_ALIGNMENT_TOP = range(3)

class MemberCurvedCantileversType(Enum):
    '''
    Member Curved Member Cantilevers Type
    '''
    CANTILEVERS_TYPE_HORIZONTAL, CANTILEVERS_TYPE_OFFSET, CANTILEVERS_TYPE_PARALLEL, CANTILEVERS_TYPE_TAPER = range(4)

class MemberRotationSpecificationType(Enum):
    ''''
    Member Rotation Specification Type
    '''
    COORDINATE_SYSTEM_ROTATION_VIA_ANGLE, COORDINATE_SYSTEM_ROTATION_VIA_HELP_NODE, COORDINATE_SYSTEM_ROTATION_VIA_INSIDE_NODE, COORDINATE_SYSTEM_ROTATION_VIA_SURFACE = range(4)

class MemberRotationPlaneType(Enum):
    '''
    Member Rotation Plane Type
    '''
    ROTATION_PLANE_XY, ROTATION_PLANE_XZ = range(2)

class StirrupType(Enum):
    '''
    Stirrup Type
    '''
    STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_135, STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_90, STIRRUP_TYPE_FOUR_LEGGED_OVERLAP_HOOK_180, \
    STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_135, STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_90, STIRRUP_TYPE_THREE_LEGGED_OVERLAP_HOOK_180, \
    STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_135, STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_90, STIRRUP_TYPE_TWO_LEGGED_OPEN, \
    STIRRUP_TYPE_TWO_LEGGED_OVERLAP_HOOK_180 = range(10)

class SpanPositionReferenceType(Enum):
    '''
    Span Position Reference Type
    '''
    SHEAR_REINFORCEMENT_SPAN_INTERNAL_NODE, SHEAR_REINFORCEMENT_SPAN_REFERENCE_END, SHEAR_REINFORCEMENT_SPAN_REFERENCE_START = range(3)

class SpanPositionDefinitionFormatType(Enum):
    '''
    Span Position Definition Format Type
    '''
    SHEAR_REINFORCEMENT_SPAN_DEFINITION_FORMAT_ABSOLUTE, SHEAR_REINFORCEMENT_SPAN_DEFINITION_FORMAT_RELATIVE = range(2)

class StirrupLayoutRuleType(Enum):
    '''
    Stirrup Layout Rule Type
    '''
    SHEAR_REINFORCEMENT_STIRRUP_LAYOUT_RULE_END_DEFINED, SHEAR_REINFORCEMENT_STIRRUP_LAYOUT_RULE_END_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED,\
    SHEAR_REINFORCEMENT_STIRRUP_LAYOUT_RULE_START_DEFINED, SHEAR_REINFORCEMENT_STIRRUP_LAYOUT_RULE_START_EQUALS_END, \
    SHEAR_REINFORCEMENT_STIRRUP_LAYOUT_RULE_START_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED = range(5)

class RebarType(Enum):
    '''
    Rebar Type
    '''
    REBAR_TYPE_LINE, REBAR_TYPE_SINGLE, REBAR_TYPE_SYMMETRICAL, REBAR_TYPE_UNIFORMLY_SURROUNDING, REBAR_TYPE_UNSYMMETRICAL = range(5)

class AdditionalOffsetType(Enum):
    '''
    Additional Offset Type
    '''
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_FROM_CONCRETE_COVER, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_FROM_SECTION_SURFACE, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_FROM_STIRRUP, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_NONE = range(4)

class AdditionalOffsetSingleLineType(Enum):
    '''
    Additional Offset Single Line Type
    '''
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_FROM_CONCRETE_COVER, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_FROM_SECTION_SURFACE, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_FROM_STIRRUP, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_NONE = range(4)

class AdditionalOffsetReferenceType(Enum):
    '''
    Additional Offset Reference Type
    '''
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_BOTTOM, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_CENTER, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_TOP, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_BOTTOM, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_CENTER, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_TOP, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_BOTTOM, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_CENTER, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_TOP = range(9)

class AdditionalOffsetReferenceStartType(Enum):
    '''
    Additional Offset Reference Type at Start Type
    '''
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_BOTTOM, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_CENTER, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_TOP, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_BOTTOM, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_CENTER, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_TOP, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_BOTTOM, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_CENTER, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_TOP = range(9)

class AdditionalOffsetReferenceEndType(Enum):
    '''
    Additional Offset Reference Type at End Type
    '''
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_BOTTOM, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_CENTER, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_TOP, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_BOTTOM, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_CENTER, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_TOP, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_BOTTOM, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_CENTER, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_TOP = range(9)

class AnchorageStartAnchorType(Enum):
    '''
    Anchorage Start Anchor Type
    '''
    ANCHORAGE_TYPE_BEND, ANCHORAGE_TYPE_HOOK, ANCHORAGE_TYPE_HOOK_WITH_TRANSVERSE_BAR, ANCHORAGE_TYPE_NONE,\
    ANCHORAGE_TYPE_STRAIGHT, ANCHORAGE_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR, ANCHORAGE_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS = range(7)

class AnchorageEndAnchorType(Enum):
    '''
    Anchorage End Anchor Type
    '''
    ANCHORAGE_TYPE_BEND, ANCHORAGE_TYPE_HOOK, ANCHORAGE_TYPE_HOOK_WITH_TRANSVERSE_BAR, ANCHORAGE_TYPE_NONE,\
    ANCHORAGE_TYPE_STRAIGHT, ANCHORAGE_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR, ANCHORAGE_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS = range(7)

class SelectedObjectInformation(Enum):
    '''
    Information About Members | Enum
    '''
    LENGTH, VOLUME, MASS, AREA = range(4)
class GlobalAxesOrientationType(Enum):
    '''
    Model Settings and Options Global Axes Orientation Type
    '''
    E_GLOBAL_AXES_ORIENTATION_ZDOWN, E_GLOBAL_AXES_ORIENTATION_ZUP = range(2)

class LocalAxesOrientationType(Enum):
    '''
    Model Settings and Local Axes Orientation Type
    '''
    E_LOCAL_AXES_ORIENTATION_YUPX, E_LOCAL_AXES_ORIENTATION_YUPZ, E_LOCAL_AXES_ORIENTATION_ZDOWN, E_LOCAL_AXES_ORIENTATION_ZUP = range(4)

class ModelType(Enum):
    '''
    Model Type | Enum
    '''
    E_MODEL_TYPE_1D_X_3D, E_MODEL_TYPE_1D_X_AXIAL, E_MODEL_TYPE_2D_XY_3D, \
    E_MODEL_TYPE_2D_XY_PLATE, E_MODEL_TYPE_2D_XZ_3D, E_MODEL_TYPE_2D_XZ_PLANE_STRAIN, \
    E_MODEL_TYPE_2D_XZ_PLANE_STRESS, E_MODEL_TYPE_3D = range(8)
class ModalSolutionMethod(Enum):
    '''
    Modal Analysis Settings Solution Method
    '''
    METHOD_ICG_ITERATION, METHOD_LANCZOS, METHOD_ROOT_OF_CHARACTERISTIC_POLYNOMIAL, METHOD_SUBSPACE_ITERATION, SOLUTION_METHOD_SHIFTED_INVERSE_POWER_METHOD = range(5)

class ModalMassConversionType(Enum):
    '''
    Modal Analysis Settings Mass Conversion Type
    '''
    MASS_CONVERSION_TYPE_FULL_LOADS_AS_MASS, MASS_CONVERSION_TYPE_Z_COMPONENTS_OF_LOADS, MASS_CONVERSION_TYPE_Z_COMPONENTS_OF_LOADS_IN_DIRECTION_OF_GRAVITY = range(3)

class ModalMassMatrixType(Enum):
    '''
    Modal Analysis Settings Mass Matrix Type
    '''
    MASS_MATRIX_TYPE_CONSISTENT, MASS_MATRIX_TYPE_DIAGONAL, MASS_MATRIX_TYPE_DIAGONAL_WITH_TORSIONAL_ELEMENTS, MASS_MATRIX_TYPE_UNIT = range(4)

class ModalModeNumberMethod(Enum):
    '''
    Modal Analysis Settings Number of Modes Method
    '''
    NUMBER_OF_MODES_METHOD_EFFECTIVE_MASS_FACTORS, NUMBER_OF_MODES_METHOD_MAXIMUM_FREQUENCY, NUMBER_OF_MODES_METHOD_USER_DEFINED = range(3)

class ModalNeglectMasses(Enum):
    '''
    Modal Analysis Settings Neglect Masses
    '''
    E_NEGLECT_MASSES_IN_ALL_FIXED_SUPPORTS, E_NEGLECT_MASSES_NO_NEGLECTION, E_NEGLECT_MASSES_USER_DEFINED = range(3)
class PeriodicResponseCombinationRule(Enum):
    '''
    Spectral Analysis Settings Combination Rule For Periodic Responses
    '''
    ABSOLUTE_SUM, CQC, SRSS = range(3)

class DirectionalComponentCombinationRule(Enum):
    '''
    Spectral Analysis Settings Combination Rule For Directional Components
    '''
    ABSOLUTE_SUM, SCALED_SUM, SRSS = range(3)

class CqsDampingRule(Enum):
    '''
    Spectal Analysis Settings Damping for CQC Rule
    '''
    CONSTANT_FOR_EACH_MODE, DIFFERENT_FOR_EACH_MODE = range(2)

class DurabilityCorrosionCarbonation(Enum):
    '''
    Concrete Durability Corrosion Induced by Carbonation
    '''
    CORROSION_INDUCED_BY_CARBONATION_TYPE_CYCLIC_WET_AND_DRY, CORROSION_INDUCED_BY_CARBONATION_TYPE_DRY_OR_PERMANENTLY_WET,\
    CORROSION_INDUCED_BY_CARBONATION_TYPE_MODERATE_HUMIDITY, CORROSION_INDUCED_BY_CARBONATION_TYPE_WET_RARELY_DRY = range(4)

class DurabilityCorrosionChlorides(Enum):
    '''
    Concrete Durability Corrosion Induced by Chlorides
    '''
    CORROSION_INDUCED_BY_CHLORIDES_TYPE_CYCLIC_WET_AND_DRY, CORROSION_INDUCED_BY_CHLORIDES_TYPE_MODERATE_HUMIDITY, CORROSION_INDUCED_BY_CHLORIDES_TYPE_WET_RARELY_DRY = range(3)

class DurabilityCorrosionSeaWater(Enum):
    '''
    Concrete Durability Corrosion Induced by Chlorised From Sea Water
    '''
    CORROSION_INDUCED_BY_CHLORIDES_FROM_SEA_WATER_TYPE_AIRBORNE_SALT, CORROSION_INDUCED_BY_CHLORIDES_FROM_SEA_WATER_TYPE_PERMANENTLY_SUBMERGED,\
    CORROSION_INDUCED_BY_CHLORIDES_FROM_SEA_WATER_TYPE_SPLASH_AND_SPRAY_ZONES = range(3)

class DurabilityFreezeThawAttack(Enum):
    '''
    Concrete Durability Freeze Thaw Attack
    '''
    FREEZE_THAW_ATTACK_TYPE_HIGH_SATURATION_DEICING, FREEZE_THAW_ATTACK_TYPE_HIGH_SATURATION_NO_DEICING,\
     FREEZE_THAW_ATTACK_TYPE_MODERATE_SATURATION_DEICING, FREEZE_THAW_ATTACK_TYPE_MODERATE_SATURATION_NO_DEICING = range(4)

class DurabilityChemicalAttack(Enum):
    '''
    Concrete Durability Chemical Attack
    '''
    CHEMICAL_ATTACK_TYPE_HIGHLY_AGGRESSIVE, CHEMICAL_ATTACK_TYPE_MODERATELY_AGGRESSIVE, CHEMICAL_ATTACK_TYPE_SLIGHTLY_AGGRESSIVE = range(3)

class DurabilityCorrosionWear(Enum):
    '''
    Concrete Durability Concrete Corrosion Induced by the Wear
    '''
    CONCRETE_CORROSION_INDUCED_BY_WEAR_TYPE_HIGH, CONCRETE_CORROSION_INDUCED_BY_WEAR_TYPE_MODERATE, CONCRETE_CORROSION_INDUCED_BY_WEAR_TYPE_VERY_HIGH = range(3)

class DurabilityStructuralClassType(Enum):
    '''
    Concrete Durability Structural Class Type
    '''
    DEFINED, STANDARD = range(2)

class DurabilityStructuralClass(Enum):
    '''
    Concrete Durability User Defined Structural Class
    '''
    S1, S2, S3, S4, S5, S6 = range(6)

class DurabilityMaxWaterToCementRatio(Enum):
    '''
    Concrete Durability Maximum Equivalent Water To Cement Ratio
    '''
    ZERO_POINT_FIVE, ZERO_POINT_FIVE_FIVE, ZERO_POINT_FOUR, ZERO_POINT_FOUR_FIVE, ZERO_POINT_NINE, ZERO_POINT_SIX, ZERO_POINT_THREE_FIVE = range(7)

class DurabilityConcreteCoverType(Enum):
    '''
    Concrete Durability Increase of Minimum Concrete Cover Type
    '''
    DEFINED, STANDARD = range(2)

class DurabilityStainlessSteelType(Enum):
    '''
    Concrete Durability Additional Protection Type
    '''
    DEFINED, STANDARD = range(2)

class DurabilityAdditionalProtectionType(Enum):
    '''
    Concrete Durability Additional Protection Type
    '''
    DEFINED, STANDARD = range(2)

class DurabilityAllowanceDeviationType(Enum):
    '''
    Concrete Durability Allowance of Deviation Type
    '''
    DEFINED, STANDARD = range(2)

class DurabilityConcreteCast(Enum):
    '''
    Concrete Durability Concrete Cast
    '''
    AGAINST_PREPARED_GROUND, DIRECTLY_AGAINST_SOIL = range(2)

class ConcreteEffectiveLengthsAxisZ(Enum):
    '''
    Concrete Effective Lengths Structure Type About Axis Z
    '''
    STRUCTURE_TYPE_BRACED, STRUCTURE_TYPE_UNBRACED = range(2)

class ConcreteEffectiveLengthAxisY(Enum):
    '''
    Concrete Effective Lengths Structure Type About Axis Y
    '''
    STRUCTURE_TYPE_BRACED, STRUCTURE_TYPE_UNBRACED = range(2)

class EffectiveLengthSupportType(Enum):
    '''
    Effective Length Nodal Support Type
    '''
    SUPPORT_TYPE_FIXED_ALL, SUPPORT_TYPE_FIXED_IN_Y, SUPPORT_TYPE_FIXED_IN_Z, SUPPORT_TYPE_FIXED_IN_Z_AND_TORSION,\
    SUPPORT_TYPE_FIXED_IN_Z_AND_TORSION_AND_WARPING, SUPPORT_TYPE_FIXED_IN_Z_Y_AND_TORSION, SUPPORT_TYPE_FIXED_IN_Z_Y_AND_TORSION_AND_WARPING,\
    SUPPORT_TYPE_INDIVIDUALLY, SUPPORT_TYPE_NONE, SUPPORT_TYPE_RESTRAINT_ABOUT_X = range(10)

class EffectiveLengthEccentricityType(Enum):
    '''
    Effective Length Eccentricity Type
    '''
    ECCENTRICITY_TYPE_AT_LOWER_FLANGE, ECCENTRICITY_TYPE_AT_UPPER_FLANGE, ECCENTRICITY_TYPE_NONE, ECCENTRICITY_TYPE_USER_VALUE = range(4)

class SupportStatus(Enum):
    '''
    Support Status
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)

class RestraintTypeAboutX(Enum):
    '''
    Restraint About X Type
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)

class RestraintTypeAboutZ(Enum):
    '''
    Restraint About X Type
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)

class RestraintTypeWarping(Enum):
    '''
    Restraint About Warping
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)

class ReinforcementDirectionType(Enum):
    '''
    Reinforcement Direction Type
    '''
    REINFORCEMENT_DIRECTION_TYPE_FIRST_REINFORCEMENT_IN_X, REINFORCEMENT_DIRECTION_TYPE_FIRST_REINFORCEMENT_IN_Y, REINFORCEMENT_DIRECTION_TYPE_ROTATED = range(3)

class SurfaceReinforcementLocationType(Enum):
    '''
    Surface Reinforcement Location Type
    '''
    LOCATION_TYPE_FREE_CIRCULAR, LOCATION_TYPE_FREE_POLYGON, LOCATION_TYPE_FREE_RECTANGULAR, LOCATION_TYPE_ON_SURFACE = range(4)

class SurfaceReinforcementType(Enum):
    '''
    Surface Reinforcement Type
    '''
    REINFORCEMENT_TYPE_MESH, REINFORCEMENT_TYPE_REBARS, REINFORCEMENT_TYPE_STIRRUPS = range(3)

class SurfaceReinforcementDirectionType(Enum):
    '''
    Surface Reinforcement Direction Type
    '''
    REINFORCEMENT_DIRECTION_TYPE_IN_DESIGN_REINFORCEMENT_DIRECTION, REINFORCEMENT_DIRECTION_TYPE_PARALLEL_TO_TWO_POINTS = range(2)

class SurfaceReinforcementDesignDirection(Enum):
    '''
    Surface Design Reinforcement Direction
    '''
    DESIGN_REINFORCEMENT_DIRECTION_A_S_1, DESIGN_REINFORCEMENT_DIRECTION_A_S_2 = range(2)

class SurfaceReinforcementProjectionPlane(Enum):
    '''
    Surface Reinforcement Projection Plane
    '''

    PROJECTION_PLANE_XY_OR_UV, PROJECTION_PLANE_XZ_OR_UW, PROJECTION_PLANE_YZ_OR_VW = range(3)

class SurfaceReinforcementLocationRectangleType(Enum):
    '''
    Surface Reinforcement Location Type
    '''
    RECTANGLE_TYPE_CENTER_AND_SIDES, RECTANGLE_TYPE_CORNER_POINTS = range(2)

class AmplitudeFunctionType(Enum):
    '''
    Amplitude Function Type
    '''
    CONSTANT, LINEAR, QUADRATIC = range(3)

class PlausibilityCheckResult(Enum):
    '''
    Plausibility Check Result
    '''
    CHECK_IS_OK, CHECK_FAILED = range(2)

class ModelCheckGetOptionType(Enum):
    '''
    Model Check Get Object Groups Option Type
    '''
    CROSSING_LINES, CROSSING_MEMBERS, IDENTICAL_NODES, OVERLAPPING_LINES, OVERLAPPING_MEMBERS = range(5)

class ModelCheckProcessOptionType(Enum):
    '''
    Model Check Process Object Groups Option Type
    '''
    CROSS_LINES, CROSS_MEMBERS, DELETE_UNUSED_NODES, UNITE_NODES_AND_DELETE_UNUSED_NODES = range(4)
class OptimizeOnType(Enum):
    '''
    Optimization Settings Optimize On Type
    '''
    E_OPTIMIZE_ON_TYPE_MIN_WHOLE_WEIGHT, E_OPTIMIZE_ON_TYPE_MIN_VECTORIAL_DISPLACEMENT, E_OPTIMIZE_ON_TYPE_MIN_MEMBER_DEFORMATION, \
    E_OPTIMIZE_ON_TYPE_MIN_SURFACE_DEFORMATION, E_OPTIMIZE_ON_TYPE_MIN_COST, E_OPTIMIZE_ON_TYPE_MIN_CO2_EMISSIONS = range(6)

class Optimizer(Enum):
    '''
    Optimization Settings Optimizer
    '''
    E_OPTIMIZER_TYPE_ALL_MUTATIONS, E_OPTIMIZER_TYPE_PERCENTS_OF_RANDOM_MUTATIONS, E_OPTIMIZER_TYPE_PARTICLE_SWARM = range(3)

class SurfacesShapeOfFiniteElements(Enum):
    '''
    Surfaces Shape of Finite Elements
    '''
    E_SHAPE_OF_FINITE_ELEMENTS_FOR_SURFACES__TRIANGLES_AND_QUADRANGLES, E_SHAPE_OF_FINITE_ELEMENTS_FOR_SURFACES__QUADRANGLES_ONLY, \
    E_SHAPE_OF_FINITE_ELEMENTS_FOR_SURFACES__TRIANGLES_ONLY = range(3)

class AddOn(Enum):
    '''
    AddOn types
    '''
    stress_analysis_active, concrete_design_active, steel_design_active, timber_design_active, aluminum_design_active, \
    steel_joints_active, timber_joints_active, craneway_design_active, masonry_design_active, multilayer_surfaces_design_active, \
    material_nonlinear_analysis_active, structure_stability_active, construction_stages_active, time_dependent_active, \
    form_finding_active, cutting_patterns_active, torsional_warping_active, cost_estimation_active, modal_active, spectral_active, \
    time_history_active, pushover_active, harmonic_response_active, building_model_active, wind_simulation_active, \
    geotechnical_analysis_active = range(26)

class SteelEffectiveLengthsBucklingFactorValueType(Enum):
    '''
    Steel Effective Lengths Buckling Factor Value Type
    '''
    BUCKLING_FACTOR_VALUE_TYPE_RECOMMENDED, BUCKLING_FACTOR_VALUE_TYPE_THEORETICAL = range(2)

class SteelEffectiveLengthsSupportType(Enum):
    '''
    Steel Effective Lengths Support Type
    '''
    SUPPORT_TYPE_FIXED_ALL, SUPPORT_TYPE_FIXED_IN_Y, SUPPORT_TYPE_FIXED_IN_Z, SUPPORT_TYPE_FIXED_IN_Z_AND_TORSION, \
    SUPPORT_TYPE_FIXED_IN_Z_AND_TORSION_AND_WARPING, SUPPORT_TYPE_FIXED_IN_Z_Y_AND_TORSION, SUPPORT_TYPE_FIXED_IN_Z_Y_AND_TORSION_AND_WARPING, \
    SUPPORT_TYPE_INDIVIDUALLY, SUPPORT_TYPE_NONE, SUPPORT_TYPE_RESTRAINT_ABOUT_X = range(10)

class SteelEffectiveLengthsEccentricityType(Enum):
    '''
    Steel Effective Lengths Eccentricity Type
    '''
    ECCENTRICITY_TYPE_AT_LOWER_FLANGE, ECCENTRICITY_TYPE_AT_UPPER_FLANGE, ECCENTRICITY_TYPE_NONE, ECCENTRICITY_TYPE_USER_VALUE = range(4)

class SteelEffectiveLengthsSupportTypeInY(Enum):
    '''
    Steel Effective Lengths Support in Y Type
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)

class SteelEffectiveLengthsRestraintTypeAboutX(Enum):
    '''
    Steel Effective Lengths Restraint About X Type
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)

class SteelEffectiveLengthsRestraintTypeAboutZ(Enum):
    '''
    Steel Effective Lengths Restraint About Z Type
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)

class SteelEffectiveLengthsRestraintTypeWarping(Enum):
    '''
    Steel Effective Lengths Restraint Warping Type
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)


class SteelEffectiveLengthsDeterminationMcrEurope(Enum):
    '''
    Steel Effective Lengths Determination MCR Europe
    '''
    DETERMINATION_EUROPE_EIGENVALUE, DETERMINATION_EUROPE_USER_DEFINED = range(2)

class SteelEffectiveLengthsDeterminationMcrIs800(Enum):
    '''
    Steel Effective Lengths Determination MCR IS 800
    '''
    DETERMINATION_IS800_EIGENVALUE, DETERMINATION_IS800_USER_DEFINED = range(2)

class SteelEffectiveLengthsDeterminationMcrAisc(Enum):
    '''
    Steel Effective Lengths Determination MCR AISC
    '''
    DETERMINATION_AISC_ACC_TO_CHAPTER_F, DETERMINATION_AISC_EIGENVALUE, DETERMINATION_AISC_USER_DEFINED = range(3)

class SteelEffectiveLengthsDeterminationMcrGb50(Enum):
    '''
    Steel Effective Lengths Determination MCR GB 50
    '''
    DETERMINATION_GB50_EIGENVALUE, DETERMINATION_GB50_NOT_USED, DETERMINATION_GB50_USER_DEFINED = range(3)

class SteelEffectiveLengthsDeterminationCbAisc(Enum):
    '''
    Steel Effective Lengths Determination CB AISC
    '''
    DETERMINATION_CB_ACC_TO_CHAPTER_F, DETERMINATION_CB_BASIC_VALUE, DETERMINATION_CB_USER_DEFINED = range(3)

class SteelEffectiveLengthsDeterminationMcrCsa(Enum):
    '''
    Steel Effective Lengths Determination MCR CSA
    '''
    DETERMINATION_CSA_ACC_TO_CHAPTER_13_6, DETERMINATION_CSA_EIGENVALUE, DETERMINATION_CSA_USER_DEFINED = range(3)

class SteelEffectiveLengthsDeterminationCbCsa(Enum):
    '''
    Steel Effective Lengths Determination CB CSA
    '''
    DETERMINATION_CB_ACC_TO_CHAPTER_13_6, DETERMINATION_CB_BASIC_VALUE, DETERMINATION_CB_USER_DEFINED = range(3)

class SteelEffectiveLengthsDeterminationMcrBs5(Enum):
    '''
    Steel Effective Lengths Determination MCR BS5
    '''
    DETERMINATION_BS5_ACC_TO_CHAPTER_F, DETERMINATION_BS5_EIGENVALUE, DETERMINATION_BS5_USER_DEFINED = range(3)

class SteelEffectiveLengthsDeterminationCbNbr(Enum):
    '''
    Steel Effective Lengths Determination CB NBR
    '''
    DETERMINATION_CB_ACC_TO_5423, DETERMINATION_CB_BASIC_VALUE, DETERMINATION_CB_USER_DEFINED = range(3)

class SteelEffectiveLengthsMomentModificationRestrainedSegments(Enum):
    '''
    Steel Effective Lengths Moment Modification Restrained Segments
    '''
    MOMENT_ALPHA_ACC_TO_5611_II, MOMENT_ALPHA_ACC_TO_5611_III, MOMENT_ALPHA_BASIC_VALUE, \
    MOMENT_ALPHA_EIGENVALUE_METHOD, MOMENT_ALPHA_USER_DEFINED = range(5)

class SteelEffectiveLengthsMomentModificationUnrestrainedSegments(Enum):
    '''
    Steel Effective Lengths Moment Modification Unrestrained Segments
    '''
    MOMENT_ALPHA_ACC_TO_5611_II, MOMENT_ALPHA_BASIC_VALUE, MOMENT_ALPHA_USER_DEFINED = range(3)

class SteelEffectiveLengthsSlendernessReductionRestrainedSegments(Enum):
    '''
    Steel Effective Lengths Slenderness Reduction Restrained Segments
    '''
    SLENDERNESS_ALPHA_ACC_TO_5611, SLENDERNESS_ALPHA_EIGENVALUE_METHOD = range(2)

class SteelEffectiveLengthsSlendernessReductionUnrestrainedSegments(Enum):
    '''
    Steel Effective Lengths Slenderness Reduction Unrestrained Segments
    '''
    SLENDERNESS_ALPHA_ACC_TO_5611, SLENDERNESS_ALPHA_EIGENVALUE_METHOD = range(2)

class SteelEffectiveLengthsMemberType(Enum):
    '''
    Steel Effective Lengths Member Type
    '''
    MEMBER_TYPE_BEAM, MEMBER_TYPE_CANTILEVER = range(2)

class SteelEffectiveLengthsMemberTypeYY(Enum):
    '''
    Steel Effective Lengths Member Type YY
    '''
    MEMBER_TYPE_BEAM, MEMBER_TYPE_CANTILEVER = range(2)

class SteelEffectiveLengthsMemberTypeZZ(Enum):
    '''
    Steel Effective Lengths Member Type ZZ
    '''
    MEMBER_TYPE_BEAM, MEMBER_TYPE_CANTILEVER = range(2)

