# coding: utf-8

"""
    FINBOURNE Notifications API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr, constr
from lusid_notifications.models.matching_pattern import MatchingPattern
from lusid_notifications.models.resource_id import ResourceId

class Subscription(BaseModel):
    """
    A subscription object  # noqa: E501
    """
    id: ResourceId = Field(...)
    display_name: constr(strict=True, min_length=1) = Field(..., alias="displayName", description="The name of the subscription")
    description: Optional[StrictStr] = Field(None, description="The summary of the services provided by the subscription")
    status: constr(strict=True, min_length=1) = Field(..., description="The current status of the subscription")
    matching_pattern: MatchingPattern = Field(..., alias="matchingPattern")
    created_at: datetime = Field(..., alias="createdAt", description="The time at which the subscription was made")
    user_id_created: constr(strict=True, min_length=1) = Field(..., alias="userIdCreated", description="The user who made the subscription")
    modified_at: datetime = Field(..., alias="modifiedAt", description="The time at which the subscription was last modified")
    user_id_modified: constr(strict=True, min_length=1) = Field(..., alias="userIdModified", description="The user who last modified the subscription")
    use_as_auth: constr(strict=True, min_length=1) = Field(..., alias="useAsAuth", description="The user to use as auth for the subscription")
    href: Optional[StrictStr] = Field(None, description="A URI for retrieving this subscription")
    __properties = ["id", "displayName", "description", "status", "matchingPattern", "createdAt", "userIdCreated", "modifiedAt", "userIdModified", "useAsAuth", "href"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Subscription:
        """Create an instance of Subscription from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of matching_pattern
        if self.matching_pattern:
            _dict['matchingPattern'] = self.matching_pattern.to_dict()
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Subscription:
        """Create an instance of Subscription from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Subscription.parse_obj(obj)

        _obj = Subscription.parse_obj({
            "id": ResourceId.from_dict(obj.get("id")) if obj.get("id") is not None else None,
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "status": obj.get("status"),
            "matching_pattern": MatchingPattern.from_dict(obj.get("matchingPattern")) if obj.get("matchingPattern") is not None else None,
            "created_at": obj.get("createdAt"),
            "user_id_created": obj.get("userIdCreated"),
            "modified_at": obj.get("modifiedAt"),
            "user_id_modified": obj.get("userIdModified"),
            "use_as_auth": obj.get("useAsAuth"),
            "href": obj.get("href")
        })
        return _obj
