# coding: utf-8

"""
    FINBOURNE Notifications API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic import BaseModel, Field, StrictStr, conlist, constr, validator

class SmsNotificationType(BaseModel):
    """
    The information required to create or update an SMS notification  # noqa: E501
    """
    type: constr(strict=True, min_length=1) = Field(..., description="The type of delivery mechanism for this notification")
    body: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="The body of the SMS")
    recipients: conlist(StrictStr, max_items=10, min_items=1) = Field(..., description="The phone numbers to which the SMS will be sent to (E.164 format)")
    __properties = ["type", "body", "recipients"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('Sms'):
            raise ValueError("must be one of enum values ('Sms')")
        return value

    @validator('body')
    def body_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[\s\S]*$", value):
            raise ValueError(r"must validate the regular expression /^[\s\S]*$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SmsNotificationType:
        """Create an instance of SmsNotificationType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SmsNotificationType:
        """Create an instance of SmsNotificationType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SmsNotificationType.parse_obj(obj)

        _obj = SmsNotificationType.parse_obj({
            "type": obj.get("type"),
            "body": obj.get("body"),
            "recipients": obj.get("recipients")
        })
        return _obj
