# lusid-notifications-sdk
FINBOURNE Technology

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.917
- Package version: 2.0.13
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.finbourne.com](https://www.finbourne.com)

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/finbourne/notifications-sdk-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/finbourne/notifications-sdk-python.git`)

Then import the package:
```python
import lusid_notifications
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import lusid_notifications
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

You'll need to provide some configuration to connect to the lusid_notifications application.
These can be provided using a secrets file or environment variables.

### Environment variables

In order to use [short lived access tokens](https://support.lusid.com/knowledgebase/article/KA-01654/en-us) you will need to have appropriate values set for the following environment variables:

``` 
FBN_TOKEN_URL,
FBN_LUSID_NOTIFICATIONS_API_URL,
FBN_USERNAME,
FBN_PASSWORD,
FBN_CLIENT_ID,
FBN_CLIENT_SECRET,
FBN_ACCESS_TOKEN
```

To use a long lived Personal Access Token, you must provide the following environment variables:
``` 
FBN_LUSID_NOTIFICATIONS_API_URL,
FBN_ACCESS_TOKEN
```

You can send your requests to lusid_notifications via a proxy, by setting `FBN_PROXY_ADDRESS`. 
If your proxy has basic auth enabled, you must akso supply `FBN_PROXY_USERNAME` and `FBN_PROXY_PASSWORD`

### Secrets file

In order to use [short lived access tokens](https://support.lusid.com/knowledgebase/article/KA-01654/en-us) you will need to have appropriate values set in a `secrets.json` file in the same folder as your script.

``` 
{
    "api":
    {
        "tokenUrl":"<your-token-url>",
        "lusid_notificationsUrl":"<FINBOURNE-application-url>",
        "username":"<your-username>",
        "password":"<your-password>",
        "clientId":"<your-client-id>",
        "clientSecret":"<your-client-secret>",
    }
}
```

To use a long lived Personal Access Token, you must provide a `secrets.json` with the following variables:
``` 
{
    "api":
    {
        "lusid_notificationsUrl":"<FINBOURNE-application-url>",
        "accessToken":"<your-access-token>"
    }
}
```

You can send your requests to lusid_notifications via a proxy, by adding a proxy section to your `secrets.json`. 
If your proxy has basic auth enabled, you must also supply a `username` and `password` in this section.

``` 
{
    "api":
    {
        "lusid_notificationsUrl":"<FINBOURNE-application-url>",
        "accessToken":"<your-access-token>"
    },
    "proxy":
    {
        "address":"<your-proxy-address>",
        "username":"<your-proxy-username>",
        "password":"<your-proxy-password>"
    }
}
```

### Using the SDK

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import lusid_notifications
from lusid_notifications.exceptions import ApiException
from pprint import pprint

import os
from lusid_notifications import (
    ApiClientFactory,
    ApplicationMetadataApi,
    EnvironmentVariablesConfigurationLoader,
    SecretsFileConfigurationLoader,
    ArgsConfigurationLoader
)

# Use the lusid_notifications ApiClientFactory to build Api instances with a configured api client
# By default this will read config from environment variables
# Then from a secrets.json file found in the current working directory
api_client_factory = ApiClientFactory()

# The ApiClientFactory can be passed an iterable of configuration loaders to read configuration from

api_url = "https://fbn-prd.lusid.com/notification"
# Path to a secrets.json file containing authentication credentials
# See https://support.lusid.com/knowledgebase/article/KA-01667/en-us
# for a detailed guide to setting up the SDK make authenticated calls to LUSID APIs
secrets_path = os.getenv("FBN_SECRETS_PATH")
app_name="LusidJupyterNotebook"

config_loaders = [
	EnvironmentVariablesConfigurationLoader(),
	SecretsFileConfigurationLoader(api_secrets_file=secrets_path),
	ArgsConfigurationLoader(api_url=api_url, app_name=app_name)
]
api_client_factory = ApiClientFactory(config_loaders=config_loaders)


# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.



# Enter a context with an instance of the ApiClientFactory to ensure the connection pool is closed after use
async with api_client_factory:
    # Create an instance of the API class
    api_instance = api_client_factory.build(ApplicationMetadataApi)

    try:
        # [EARLY ACCESS] ListAccessControlledResources: Get resources available for access control
        api_response = await api_instance.list_access_controlled_resources()
        print("The response of ApplicationMetadataApi->list_access_controlled_resources:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ApplicationMetadataApi->list_access_controlled_resources: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://fbn-prd.lusid.com/notification*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApplicationMetadataApi* | [**list_access_controlled_resources**](docs/ApplicationMetadataApi.md#list_access_controlled_resources) | **GET** /api/metadata/access/resources | [EARLY ACCESS] ListAccessControlledResources: Get resources available for access control
*DeliveriesApi* | [**list_deliveries**](docs/DeliveriesApi.md#list_deliveries) | **GET** /api/deliveries | [EXPERIMENTAL] ListDeliveries: List Deliveries
*EventTypesApi* | [**get_event_type**](docs/EventTypesApi.md#get_event_type) | **GET** /api/eventtypes/{eventType} | [EXPERIMENTAL] GetEventType: Gets the specified event type schema.
*EventTypesApi* | [**list_event_types**](docs/EventTypesApi.md#list_event_types) | **GET** /api/eventtypes | [EXPERIMENTAL] ListEventTypes: Lists all of the available event types.
*ManualEventApi* | [**trigger_manual_event**](docs/ManualEventApi.md#trigger_manual_event) | **POST** /api/manualevent | [EXPERIMENTAL] TriggerManualEvent: Trigger a manual event.
*NotificationsApi* | [**create_notification**](docs/NotificationsApi.md#create_notification) | **POST** /api/subscriptions/{scope}/{code}/notifications | [EXPERIMENTAL] CreateNotification: Add a Notification to a Subscription.
*NotificationsApi* | [**delete_notification**](docs/NotificationsApi.md#delete_notification) | **DELETE** /api/subscriptions/{scope}/{code}/notifications/{id} | [EXPERIMENTAL] DeleteNotification: Delete a notification for a given subscription.
*NotificationsApi* | [**get_notification**](docs/NotificationsApi.md#get_notification) | **GET** /api/subscriptions/{scope}/{code}/notifications/{id} | [EXPERIMENTAL] GetNotification: Get a notification on a subscription.
*NotificationsApi* | [**list_notifications**](docs/NotificationsApi.md#list_notifications) | **GET** /api/subscriptions/{scope}/{code}/notifications | [EXPERIMENTAL] ListNotifications: List all notifications on a subscription.
*NotificationsApi* | [**update_notification**](docs/NotificationsApi.md#update_notification) | **PUT** /api/subscriptions/{scope}/{code}/notifications/{id} | [EXPERIMENTAL] UpdateNotification: Update a Notification for a Subscription
*SubscriptionsApi* | [**create_subscription**](docs/SubscriptionsApi.md#create_subscription) | **POST** /api/subscriptions | [EXPERIMENTAL] CreateSubscription: Create a new subscription.
*SubscriptionsApi* | [**delete_subscription**](docs/SubscriptionsApi.md#delete_subscription) | **DELETE** /api/subscriptions/{scope}/{code} | [EXPERIMENTAL] DeleteSubscription: Delete a subscription.
*SubscriptionsApi* | [**get_subscription**](docs/SubscriptionsApi.md#get_subscription) | **GET** /api/subscriptions/{scope}/{code} | [EXPERIMENTAL] GetSubscription: Get a subscription.
*SubscriptionsApi* | [**list_subscriptions**](docs/SubscriptionsApi.md#list_subscriptions) | **GET** /api/subscriptions | [EXPERIMENTAL] ListSubscriptions: List subscriptions.
*SubscriptionsApi* | [**update_subscription**](docs/SubscriptionsApi.md#update_subscription) | **PUT** /api/subscriptions/{scope}/{code} | [EXPERIMENTAL] UpdateSubscription: Update an existing subscription.


## Documentation For Models

 - [AccessControlledAction](docs/AccessControlledAction.md)
 - [AccessControlledResource](docs/AccessControlledResource.md)
 - [ActionId](docs/ActionId.md)
 - [AmazonSqsNotificationType](docs/AmazonSqsNotificationType.md)
 - [AmazonSqsNotificationTypeResponse](docs/AmazonSqsNotificationTypeResponse.md)
 - [AmazonSqsPrincipalAuthNotificationType](docs/AmazonSqsPrincipalAuthNotificationType.md)
 - [AmazonSqsPrincipalAuthNotificationTypeResponse](docs/AmazonSqsPrincipalAuthNotificationTypeResponse.md)
 - [Attempt](docs/Attempt.md)
 - [AttemptStatus](docs/AttemptStatus.md)
 - [CreateNotificationRequest](docs/CreateNotificationRequest.md)
 - [CreateSubscription](docs/CreateSubscription.md)
 - [Delivery](docs/Delivery.md)
 - [EmailNotificationType](docs/EmailNotificationType.md)
 - [EmailNotificationTypeResponse](docs/EmailNotificationTypeResponse.md)
 - [EventFieldDefinition](docs/EventFieldDefinition.md)
 - [EventTypeSchema](docs/EventTypeSchema.md)
 - [IdSelectorDefinition](docs/IdSelectorDefinition.md)
 - [IdentifierPartSchema](docs/IdentifierPartSchema.md)
 - [Link](docs/Link.md)
 - [LusidProblemDetails](docs/LusidProblemDetails.md)
 - [LusidValidationProblemDetails](docs/LusidValidationProblemDetails.md)
 - [ManualEvent](docs/ManualEvent.md)
 - [ManualEventBody](docs/ManualEventBody.md)
 - [ManualEventHeader](docs/ManualEventHeader.md)
 - [ManualEventRequest](docs/ManualEventRequest.md)
 - [MatchingPattern](docs/MatchingPattern.md)
 - [Notification](docs/Notification.md)
 - [NotificationStatus](docs/NotificationStatus.md)
 - [NotificationType](docs/NotificationType.md)
 - [NotificationTypeResponse](docs/NotificationTypeResponse.md)
 - [ResourceId](docs/ResourceId.md)
 - [ResourceListOfAccessControlledResource](docs/ResourceListOfAccessControlledResource.md)
 - [ResourceListOfDelivery](docs/ResourceListOfDelivery.md)
 - [ResourceListOfEventTypeSchema](docs/ResourceListOfEventTypeSchema.md)
 - [ResourceListOfNotification](docs/ResourceListOfNotification.md)
 - [ResourceListOfSubscription](docs/ResourceListOfSubscription.md)
 - [SmsNotificationType](docs/SmsNotificationType.md)
 - [SmsNotificationTypeResponse](docs/SmsNotificationTypeResponse.md)
 - [Subscription](docs/Subscription.md)
 - [UpdateNotificationRequest](docs/UpdateNotificationRequest.md)
 - [UpdateSubscription](docs/UpdateSubscription.md)
 - [WebhookNotificationType](docs/WebhookNotificationType.md)
 - [WebhookNotificationTypeResponse](docs/WebhookNotificationTypeResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="oauth2"></a>
### oauth2

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://lusid.okta.com/oauth2/default/v1/authorize
- **Scopes**: N/A


## Author

info@finbourne.com


